package sensorBoard.io;

import sensorBoard.ISensorBoardComponent;
import sensorBoard.ISensorBoardComponentListener;

import com.CharNotValidException;
import com.Event;
import com.LedsManager;
import com.ParamNotFoundException;
import com.ParamsLabel;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.resources.transducers.ISwitch;
import com.sun.spot.resources.transducers.ISwitchListener;
import com.sun.spot.resources.transducers.LEDColor;
import com.sun.spot.resources.transducers.SwitchEvent;

/**
 * Provides a listener class for node switches. 
 * Send a backEvent to own manager when the switch state changes (PRESSED OR RELEASED)
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class SwitchListener implements ISwitchListener, ISensorBoardComponentListener {
	
	private ISensorBoardComponent sensorBoardComponent;
	private String ioID;
	private	Event backEvent;
	private boolean pressed;
	private boolean released;
	private ISwitch [] iSwitches;
	private int index;
	boolean permanent;
	
	/**
	 * Creates a new SwitchListener.
	 * @param sensorBoardComponent component that invokes the constructor and manages the backEvent 
	 * @param ioID own ID
	 * @param backEvent backEvent to send when the switch state changes
	 */
	public SwitchListener (ISensorBoardComponent sensorBoardComponent, String ioID, Event backEvent) {
		
		try {
			this.sensorBoardComponent = sensorBoardComponent;
			this.ioID = ioID;
			this.backEvent = backEvent;
			this.backEvent.setParam(ParamsLabel.INO_ID, ioID);
			if (backEvent.getParam(ParamsLabel.SWT_PRESSED).equals("true"))
				this.pressed = true;
			else
				this.pressed = false;
			if (backEvent.getParam(ParamsLabel.SWT_RELEASED).equals("true"))
				this.released = true;
			else
				this.released = false;
			index = Integer.parseInt(backEvent.getParam(ParamsLabel.SWT_INDEX));
			this.iSwitches = EDemoBoard.getInstance().getSwitches();
			switch (index) {
				case 0:
					iSwitches[0].addISwitchListener(this);
				break;
				case 1:
					iSwitches[1].addISwitchListener(this);
				break;
				case 2:
					iSwitches[0].addISwitchListener(this);
					iSwitches[1].addISwitchListener(this);
				break;
			}
			if (backEvent.getType() == Event.PERMANENT)
				this.permanent = true;
			else
				this.permanent = false;
		}
		catch (ParamNotFoundException e) {
			e.printStackTrace();
			return;
		}
		catch (CharNotValidException e) {
			e.printStackTrace();
			return;
		}
		
	}
	

	public void switchPressed(ISwitch iSwitch) {
		try {
			if (this.pressed) {
				if (iSwitch == this.iSwitches[0])
					backEvent.setParam(ParamsLabel.SWT_INDEX, "" + 0);
				else
					backEvent.setParam(ParamsLabel.SWT_INDEX, "" + 1);
				backEvent.setParam(ParamsLabel.SWT_ACTION, "pressed");
				this.sensorBoardComponent.send(backEvent);
				if (!permanent)
					this.sensorBoardComponent.terminateListener(this.ioID);
			}
		}
		catch (CharNotValidException e) {
			LedsManager.error(LEDColor.YELLOW);
			e.printStackTrace();
		}
	}
		
	public void switchReleased(ISwitch iSwitch) {
		try {
			if (this.released) {
				if (iSwitch == this.iSwitches[0])
					backEvent.setParam(ParamsLabel.SWT_INDEX, "" + 0);
				else
					backEvent.setParam(ParamsLabel.SWT_INDEX, "" + 1);
				backEvent.setParam(ParamsLabel.SWT_ACTION, "released");
				this.sensorBoardComponent.send(backEvent);
				if (!permanent)
					this.sensorBoardComponent.terminateListener(this.ioID);
			}
		}
		catch (CharNotValidException e) {
			LedsManager.error(LEDColor.YELLOW);
			e.printStackTrace();
		}
	}
	
	public boolean terminateListener () {
		switch (index) {
			case 0:
				this.iSwitches[0].removeISwitchListener(this);
			break;
			case 1:
				this.iSwitches[1].removeISwitchListener(this);
			break;
			case 2:
				this.iSwitches[0].removeISwitchListener(this);
				this.iSwitches[1].removeISwitchListener(this);
			break;
		}
		return true;
		
	}

	public String getSensorBoardComponentID() {
		return ioID;
	}


	public void switchPressed(SwitchEvent arg0) {
		
	}


	public void switchReleased(SwitchEvent arg0) {
		
	}



	
}
