package server;

import server.interfaces.IMobileAgentExecutionEngine;
import server.interfaces.IMobileAgentServer;
import server.interfaces.InvalidCommunicationPortException;

import com.Constants;


public class MobileAgentServer implements IMobileAgentServer {
	
	private IMobileAgentExecutionEngine executionEngine;
	
	/**
	 * Creates a MobileAgentServer
	 */
	public MobileAgentServer () {
		this.executionEngine = Factory.getIMobileAgentExecutionEngine(Constants.DEFAULT_COMMUNICATION_PORT);
	}
	
	/**
	 * Creates a MobileAgentServer
	 * @param communicationPort Communication Port number
	 * @throws InvalidCommunicationPortException 
	 */
	public MobileAgentServer (String communicationPort) throws InvalidCommunicationPortException {
		if (communicationPort.equals(Constants.MIGRATION_PORT))
			throw new InvalidCommunicationPortException();
		this.executionEngine = Factory.getIMobileAgentExecutionEngine(communicationPort);
	}
	
	
	public boolean addAgent(String agentName, String [] params) {

		return this.executionEngine.create("", agentName, params, this.getMyIEEEAddress());

	}
	
	public boolean addAgent(String agentSuffix, String agentName, String [] params) {
		
		return this.executionEngine.create(agentSuffix, "", agentName, params, this.getMyIEEEAddress());

	}
	
	public String getMyIEEEAddress() {
		return this.executionEngine.getMyIEEEAddress().asDottedHex();
	}
	
}
