package server.interfaces;

import com.Event;

/**
 * Implemented by class wanting to manage events for local agents. 
 * Provides asynchronous communication between ExecutionEngine and local Agents.
 * Extends Runnable, because it must be a thread always ready to manage events.
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface IDispatcher extends Runnable {
	
	/**
	 * Sends events to local agents
	 * @param event event to send
	 */
	public void send(Event event);
	
}