package server.interfaces;

/**
 * Implemented by class wanting to be a proxy between developer application and ExecutionEngine.
 * It provides only the necessary Execution Engine's functions to the developer. Just with these
 * functions is possible to develop a working application
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface IMobileAgentServer {
	
	/**
	 * Creates a new agent in the local node or in a remote node.
	 * @param agentName name of the agent's class
	 * @param params parameters for the agent creation
	 * @return true if the operation was successful, false otherwise
	 */
	public boolean addAgent(String agentName, String [] params); 

	/**
	 * The difference with "create(String agentID, String sourceMA, String agent, String [] params, String nodeID)"
	 * is that here is possible to specify the ID of the agent
	 * @param agentSuffix ID's suffix
	 * @param agentName name of the agent's class
	 * @param params parameters for the agent creation
	 * @return true if the operation was successful, false otherwise
	 */
	public boolean addAgent(String agentSuffix, String agentName, String [] params);
	
	/**
	 * Gets the IEEE local address
	 * @return the IEEE local address
	 */
	public String getMyIEEEAddress();
	
}
