package ffmpegWrapper;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import utils.StaticUtils;

public class Encoder {
	
	public static final String CODEC_X264   = "libx264",
					    CODEC_FAAC   = "libfaac",
					    CODEC_FDKAAC = "libfdk_aac", //don't forget: -cutoff 21000 (to avoid low pass filter) 
					    CODEC_MP3    = "libmp3lame",
					    
					    DEINTERLACE_YADIF = "yadif";
	
	//TODO video filter param - diff special class
	private Parameters _inputParams = new Parameters(" ", " ", "-"),
					   _outParams   = new Parameters(" ", " ", "-"),
					   _inFileParam = new Parameters(" ", " ", "-");
	public  Parameters _videoFilter = new Parameters("=", ",", ""),
					   _x264Opt     = new Parameters("=", ":", ""); //keep public for now
	private File _outFile, _inFile; //not Parameters type because no key, only value
	private Process _pr = null;
	private BufferedReader _inStream;
	private BufferedReader _errStream;
	
	private File _ffPath;
	
	

	public Encoder(){
		FfmpegLocator ffLocator = new FfmpegLocator();
		_ffPath = ffLocator.getFfPath(ffLocator.FFMPEG);
	}
	
	public void setVideoCoder(String coder){
		
	}
	
	public void setAudioCoder(String coder){
		
	}
	
	public void deinterlace(boolean b, String method){
		
	}
	
	public void addSubtitle(File subtitlePath){
		
	}
	
	public void addX264Options (String parameter, String value){ //check for file existence 
		
	}
	
	public void addAudioOption (String parameter, String value){
		
	}
	
	public void resize (boolean b, Dimension d, String scaler){
		
	}
	
	public void overrideAudio (boolean b, File file){ //in case of b=false, provide file=null
		//TODO parse with ffprobe to ensure validness
	}
	
	public void enableAudio(boolean b){
		
	}
	
	public void addInputParameter(String parameter, String value){ //without "-" in parameter
		
	}
	
	public void addOutputParameter(String parameter, String value){ //without "-" in parameter
		
	}
	
	public void setInputFile (File ifile){
		
	}
	
	public void setOutputFile (File ofile){ //should be padWithQuotes - only value
		
	}
	
	/**
	 * 
	 * @return the stdout of ffmpeg
	 */
	public BufferedReader getInStream(){
		return _inStream;
	}
	
	/**
	 * 
	 * @return error stream
	 */
	public BufferedReader getErrStream(){
		return _errStream;
	}
	
	/**
	 * @return the full command line
	 */
	public String toString(){
		return StaticUtils.implode(new String[]{
		                            StaticUtils.padWithQuotes(_ffPath.getAbsolutePath()),
		                            _inputParams.toString(),
		                            StaticUtils.padWithQuotes(_inFileParam.toString()),
		                            _outParams.toString(),
		                            _outFile.getAbsolutePath()
									}, " ");
	}
	
	
	/**
	 * Initiates a run
	 * @return the process
	 */
	public Process run(){
		ProcessBuilder ps=new ProcessBuilder(toString());
    	
    	
		try {
			_pr = ps.start();
		} catch (IOException e1) {
			e1.printStackTrace();
		}  
    	
    	_inStream = new BufferedReader(new InputStreamReader(_pr.getInputStream()));   	
    	_errStream = new BufferedReader(new InputStreamReader(_pr.getErrorStream()));
    	
    	try {
			_pr.waitFor();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
    	
    	return _pr;
	}

}
