package gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.FileDrop;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import java.awt.Font;

public class FilesPanel extends JScrollPane {

	
	final private List<InputClipRow> clipsRowList = new ArrayList<InputClipRow>();
	private JPanel rowContainer;
	private JPanel rows;
	private int idCounter = 0;
	private JLabel lblDropFilesHere;
	
	/**
	 * Create the panel.
	 */
	public FilesPanel() {
		setBounds(0, 0, 520, 361);
		setBackground(new Color(239, 234, 226, 255));
		setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		
		rowContainer = new JPanel();
		rowContainer.setPreferredSize(new Dimension(490, 200));
		rowContainer.setMinimumSize(rowContainer.getPreferredSize());
		rowContainer.setLayout(new GridLayout(0, 1, 0, 10));
		rowContainer.setBackground(new Color(239, 234, 226, 255));
		
		JPanel borderLayoutPanel = new JPanel();
		borderLayoutPanel.setBackground(new Color(239, 234, 226, 255));
		((FlowLayout) borderLayoutPanel.getLayout()).setVgap(0);
		((FlowLayout) borderLayoutPanel.getLayout()).setHgap(0);
		setViewportView(borderLayoutPanel);
		
		borderLayoutPanel.add(rowContainer, BorderLayout.NORTH);
		
		setBorder(null);
		
		rows = new JPanel();
		rows.setPreferredSize(new Dimension(200,60));
		rows.setMinimumSize(rows.getPreferredSize());
		rows.setBackground(new Color(239, 234, 226, 255));
		rows.setLayout(new GridLayout(0, 1, 0, 10));;
        rows.setBackground(new Color(60, 60, 60, 0));
        
        lblDropFilesHere = new JLabel("Drop Files Here...");
        lblDropFilesHere.setFont(new Font("Tahoma", Font.BOLD, 12));
        lblDropFilesHere.setHorizontalAlignment(SwingConstants.CENTER);
        lblDropFilesHere.setSize(300, 200);
        rows.add(lblDropFilesHere);
        
        rowContainer.add(rows);
       
        new FileDrop(this, new FileDrop.Listener() {
			
			@Override
			public void filesDropped(File[] files) {
				if (lblDropFilesHere.isVisible()){
					rowContainer.setPreferredSize(new Dimension(490, 0));
					rows.remove(lblDropFilesHere);
					lblDropFilesHere.setVisible(false);
				}
				addClips(files);
				if (!clipsRowList.isEmpty())
					SettingsPanel.btnConvert.setEnabled(true);
			}
		});
        
	}
	
	public void addClips(File[] file){
		int PrevListSize = clipsRowList.size();
		
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		PlsWaitMsg msg = null;
		try {
			msg = new PlsWaitMsg((screen.width / 2)-(260 / 2), (screen.height / 2) - (144 / 2));
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
		
		
		for (int i=0; i<file.length; i++){
			InputClipRow icr = new InputClipRow(file[i]);
			if(icr.isExist()){
				System.out.println("to " + file[i].getName() + " id: " + idCounter);
				icr.setName(Integer.toString(idCounter)); //to serialize objects
				clipsRowList.add(icr);
				idCounter++;
			}
		}
		
		msg.setVisible(false);
		
		Thread[] threadsarr = new Thread[clipsRowList.size()-PrevListSize];
		
		for (int i=0; i<threadsarr.length; i++){
			threadsarr[i] = new Thread(new threadRun(PrevListSize+i, rows, rowContainer));
			threadsarr[i].start();
			try {
				threadsarr[i].join(); //mustn't be parallel
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		
		
	}
	
	private int getListIndexByName(int id){
		int getIdInList = -1;
		for (int i=0; i<clipsRowList.size();i++){
			if (Integer.parseInt(clipsRowList.get(i).getName()) == id){
				getIdInList = i;
				return getIdInList;
			}
		}
		return getIdInList;
	}
	
	private void redrawMe(){
		rows.removeAll();
		for (Iterator<InputClipRow> i = clipsRowList.iterator(); i.hasNext(); )
			rows.add(i.next());
		getParent().repaint();
	}
	
	public void deleteClip (int id){
		int getIdInList = getListIndexByName(id);
		System.out.println(getIdInList);
		clipsRowList.get(getIdInList).setVisible(false); 
		clipsRowList.remove(getIdInList);
		rowContainer.setPreferredSize(new Dimension(rowContainer.getPreferredSize().width, rowContainer.getPreferredSize().height-95));
		rows.remove(getIdInList);
		
		if (clipsRowList.isEmpty())
			SettingsPanel.btnConvert.setEnabled(false);
	}
	
	
	public void moveUp (int id){
		System.out.println("im here");
		int getIdInList = getListIndexByName(id);
		if (getIdInList <= 0)
			return;
		InputClipRow temp = clipsRowList.get(getIdInList);
		clipsRowList.set(getIdInList, clipsRowList.get(getIdInList-1));
		clipsRowList.set(getIdInList-1, temp);
		
		//lazy solution - redraw......
		redrawMe();
	}
	
	public void moveDown (int id){
		System.out.println("im here");
		int getIdInList = getListIndexByName(id);
		if (getIdInList >= clipsRowList.size()-1)
			return;
		InputClipRow temp = clipsRowList.get(getIdInList);
		clipsRowList.set(getIdInList, clipsRowList.get(getIdInList+1));
		clipsRowList.set(getIdInList+1, temp);
		
		//lazy solution - redraw......
		redrawMe();
	}
	
	private class threadRun implements Runnable {

		private int _i;
		private JPanel _rows;
		private JPanel _rowContainer;
		
		   public threadRun(int i, JPanel r, JPanel rc) {
		       _i=i;
		       _rows = r;
		       _rowContainer = rc;
		   }

		   public void run() {
			   _rows.add(clipsRowList.get(_i));
			   _rowContainer.setPreferredSize(new Dimension(_rowContainer.getPreferredSize().width, _rowContainer.getPreferredSize().height+95));
		   }
	}

}
