package gui;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JLabel;
import java.awt.Font;
import javax.swing.SwingConstants;
import javax.swing.JSeparator;
import javax.swing.JButton;
import javax.swing.JTextArea;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.UIManager;
import javax.swing.ImageIcon;

import utils.StaticUtils;

public class SettingsPanel extends JPanel {
	private JTextField textFieldWidth;
	private JTextField textField;
	private JTextField textFieldOutputFolder;
	private JCheckBox chckbxResize;
	private JLabel lblX;
	private JLabel lblAspectRatio;
	private JRadioButton rdbtnChange;
	private JRadioButton rdbtnKeep;
	private JRadioButton rdbtnPad;
	private File _outputDir;
	
	
	public static JButton btnConvert = new JButton("");

	/**
	 * Create the panel.
	 */
	public SettingsPanel() {
		setBackground(new Color(239, 237, 226, 255));
		setLayout(null);
		
		JPanel panelPresetChooserGruop = new JPanel();
		panelPresetChooserGruop.setBorder(BorderFactory.createTitledBorder("Choose Preset"));
		panelPresetChooserGruop.setBounds(10, 11, 490, 53);
		add(panelPresetChooserGruop);
		panelPresetChooserGruop.setLayout(null);
		
		JComboBox comboBox = new JComboBox();
		comboBox.setBounds(10, 22, 260, 20);
		panelPresetChooserGruop.add(comboBox);
		
		JComboBox comboBox_1 = new JComboBox();
		comboBox_1.setBounds(280, 22, 200, 20);
		panelPresetChooserGruop.add(comboBox_1);
		
		
		JPanel panelSettings = new JPanel();
		panelSettings.setBorder(BorderFactory.createTitledBorder("Settings"));
		panelSettings.setBounds(255, 75, 245, 139);
		add(panelSettings);
		panelSettings.setLayout(null);
		
			ButtonGroup groupSettings = new ButtonGroup();
			
				JRadioButton rdbtnUseDef = new JRadioButton("Use preset defaults");
				rdbtnUseDef.setBounds(5, 15, 126, 23);
				rdbtnUseDef.setSelected(true);
				rdbtnUseDef.addActionListener(new toggleSettingsListener());
				groupSettings.add(rdbtnUseDef);
				
				JRadioButton rdbtnManual = new JRadioButton("Manual");
				rdbtnManual.setBounds(133, 15, 62, 23);
				rdbtnManual.addActionListener(new toggleSettingsListener());
				groupSettings.add(rdbtnManual);
			
			panelSettings.add(rdbtnUseDef);
			panelSettings.add(rdbtnManual);
			
			chckbxResize = new JCheckBox("Resize");
			chckbxResize.setEnabled(false);
			chckbxResize.setBounds(6, 44, 62, 23);
			chckbxResize.addActionListener(new toggleResizeListener());
			panelSettings.add(chckbxResize);
			
			textFieldWidth = new JTextField();
			textFieldWidth.setEnabled(false);
			textFieldWidth.setHorizontalAlignment(SwingConstants.CENTER);
			textFieldWidth.setBounds(68, 45, 50, 20);
			panelSettings.add(textFieldWidth);
			textFieldWidth.setColumns(10);
			
			lblX = new JLabel("X");
			lblX.setEnabled(false);
			lblX.setFont(new Font("Tahoma", Font.BOLD, 12));
			lblX.setBounds(121, 48, 8, 14);
			panelSettings.add(lblX);
			
			textField = new JTextField();
			textField.setEnabled(false);
			textField.setHorizontalAlignment(SwingConstants.CENTER);
			textField.setBounds(132, 45, 50, 20);
			panelSettings.add(textField);
			textField.setColumns(10);
			
			lblAspectRatio = new JLabel("Aspect Ratio:");
			lblAspectRatio.setEnabled(false);
			lblAspectRatio.setBounds(10, 76, 73, 14);
			panelSettings.add(lblAspectRatio);
			
			ButtonGroup groupAR = new ButtonGroup();
			
				rdbtnChange = new JRadioButton("Change");
				rdbtnChange.setEnabled(false);
				rdbtnChange.setBounds(83, 72, 62, 23);
				groupAR.add(rdbtnChange);
				panelSettings.add(rdbtnChange);
				
				rdbtnKeep = new JRadioButton("Keep");
				rdbtnKeep.setEnabled(false);
				rdbtnKeep.setBounds(142, 72, 50, 23);
				groupAR.add(rdbtnKeep);
				panelSettings.add(rdbtnKeep);
				
				rdbtnPad = new JRadioButton("Pad");
				rdbtnPad.setEnabled(false);
				rdbtnPad.setBounds(188, 72, 43, 23);
				groupAR.add(rdbtnPad);
				panelSettings.add(rdbtnPad);
			
			textFieldOutputFolder = new JTextField();
			textFieldOutputFolder.setBounds(107, 108, 131, 20);
			panelSettings.add(textFieldOutputFolder);
			textFieldOutputFolder.setColumns(10);
			
			_outputDir = new File(StaticUtils.getMydocumentsDirWinOnly());
			if (_outputDir.isDirectory() && _outputDir.canWrite()){
				_outputDir = new File(_outputDir, "MGT converted videos");
			}
			if (!_outputDir.exists() && !_outputDir.mkdir())
				_outputDir = new File("C:\\");
			textFieldOutputFolder.setText(_outputDir.getAbsolutePath());
			
			JSeparator separator = new JSeparator();
			separator.setBounds(6, 101, 232, 2);
			panelSettings.add(separator);
			
			JButton btnOutputFolder = new JButton("Output Folder");
			btnOutputFolder.setBounds(6, 107, 99, 23);
			btnOutputFolder.addActionListener(new outPutDirListener());
			panelSettings.add(btnOutputFolder);
			
		JPanel panelDesc = new JPanel();
		panelDesc.setBackground(UIManager.getColor("info"));
		panelDesc.setBorder(BorderFactory.createTitledBorder("Preset Description"));
		panelDesc.setBounds(10, 75, 241, 139);
		add(panelDesc);
		panelDesc.setLayout(null);
		
		JTextArea txtrISeeIn = new JTextArea();
		txtrISeeIn.setFont(new Font("Arial", Font.PLAIN, 12));
		txtrISeeIn.setWrapStyleWord(true);
		txtrISeeIn.setLineWrap(true);
		txtrISeeIn.setText("I see in your eyes the same fear tht would take the heart of me.\r\nAnd the Day mAY COME WHEN THE COUFDYFDUHJ \r\nFDFDFD DDDSDSSD DDD hdffhkk kdfjsdkf ddd");
		txtrISeeIn.setBackground(UIManager.getColor("info"));
		txtrISeeIn.setEditable(false);
		txtrISeeIn.setBounds(6, 14, 232, 121);
		panelDesc.add(txtrISeeIn);
		panelSettings.setLayout(null);
		
		btnConvert.setEnabled(false);
		btnConvert.setIcon(new ImageIcon(SettingsPanel.class.getResource("/imgs/settingsIcons/convertStart.png")));
		btnConvert.setBounds(168, 233, 170, 48);
		add(btnConvert);
	}
	
	private void toggleResize() {
		if (chckbxResize.isSelected()){
			textFieldWidth.setEnabled(true);
			lblX.setEnabled(true);
			textField.setEnabled(true);
		} else {
			textFieldWidth.setEnabled(false);
			lblX.setEnabled(false);
			textField.setEnabled(false);
		}
	}
	
	private class toggleSettingsListener implements ActionListener{

		@Override
		public void actionPerformed(ActionEvent e) {
			if (((JRadioButton)e.getSource()).getText().equals("Manual")){
				chckbxResize.setEnabled(true);
				toggleResize();
				lblAspectRatio.setEnabled(true);
				rdbtnChange.setEnabled(true);
				rdbtnKeep.setEnabled(true);
				rdbtnPad.setEnabled(true);
			} else {
				chckbxResize.setEnabled(false);
				textFieldWidth.setEnabled(false);
				lblX.setEnabled(false);
				textField.setEnabled(false);
				lblAspectRatio.setEnabled(false);
				rdbtnChange.setEnabled(false);
				rdbtnKeep.setEnabled(false);
				rdbtnPad.setEnabled(false);
			}
			
		}
		
	}
	
	private class toggleResizeListener implements ActionListener{
		@Override
		public void actionPerformed(ActionEvent e) {			
			toggleResize();
		}	
	}
	
	private class outPutDirListener implements ActionListener{
		@Override
		public void actionPerformed(ActionEvent e) {

			JFileChooser outDirChooser = new JFileChooser();
			outDirChooser.setDialogType(JFileChooser.OPEN_DIALOG);
			outDirChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			outDirChooser.setDialogTitle("Choose destination folder...");
			
			if (outDirChooser.showOpenDialog(SettingsPanel.this) == JFileChooser.APPROVE_OPTION){
				File outDir = outDirChooser.getSelectedFile();
				if (outDir.canWrite()){
					_outputDir = outDir;
					textFieldOutputFolder.setText(_outputDir.getAbsolutePath());
				} else {
					StaticUtils.errorMsg(outDir.getAbsolutePath() + "\nThe directory is write protected!");
				}
				
			}
			
		}
	}
}
