package utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.ImageIcon;

import ffmpegWrapper.FfmpegLocator;

public class VideoFile implements GlobalConstants {

	private File _file;
	private File _subtitle;
	private boolean _deinterlace = false;
	
	private XmlHandler _ffprobeParse;
	private XmlHandler _ffprobeParseFormat;
	private ImageIcon _thumbnail;
	private FfmpegLocator _ffprobe;
	private FfmpegLocator _ffmpeg;
	
	public VideoFile(File file){
		_ffprobe = new FfmpegLocator();
		if (file.isFile()){
			_file = file;
			String ffPath = StaticUtils.padWithQuotes(_ffprobe.getFfPath(_ffprobe.FFPROBE).getAbsolutePath());
			String cmd = ffPath + " -v quiet -print_format xml -i \"" + file.getAbsolutePath() + "\" -show_format -show_streams";
			//System.out.println(StaticUtils.getStdOutStr(cmd));
			String stdOut = StaticUtils.getStdOutStr(cmd);
			_ffprobeParse = new XmlHandler(stdOut);
			_ffprobeParse.loadNodesByName("stream");
			_ffprobeParseFormat = new XmlHandler(stdOut);
			_ffprobeParseFormat.loadNodesByName("format");
		}
		
		if (isValid()){
			createThumbnail();
		}
	}
	
	public boolean isValid(){
		return !(_file == null || _ffprobeParse == null || _ffprobeParse.isEmpty() || _ffprobeParse.hasVideo() == -1 || _ffprobeParseFormat.isImage()); 
	}
	
	public ImageIcon getThumb(){
		return _thumbnail;
	}
	
	public String getDiameters(){
		String width = _ffprobeParse.getAttribute("width", _ffprobeParse.hasVideo());
		String height = _ffprobeParse.getAttribute("height", _ffprobeParse.hasVideo());
		return width+"x"+height;
	}
	
	public Float getFramerate(){
		float frameRate; // FrameRate
		String[] frStr = _ffprobeParse.getAttribute("r_frame_rate", _ffprobeParse.hasVideo()).split("/");
		frameRate = Float.parseFloat(frStr[0]);
		float tmp;
		if ((tmp = Float.parseFloat(frStr[1])) != 0.0)
			frameRate /= tmp;
		return frameRate;
		//return _ffprobeParse.getAttribute("r_frame_rate", _ffprobeParse.hasVideo());
	}
	
	public long getDuration(){
		return (long)(Float.parseFloat(_ffprobeParseFormat.getAttribute("duration", 0)));

	}
	
	public String[] getAudioStreams(){
		return _ffprobeParse.getAudioStreamRepresentation();
	}
	
	public void setDeinterlace(boolean b){
		_deinterlace = b;
	}
	
	public boolean getDeinterlace(){
		return _deinterlace;
	}
	
	public void setSubtitle(File subtitle){
		_subtitle = subtitle;
	}
	
	public File getSubtitle(){
		return _subtitle;
	}
	
	private void createThumbnail(){
		
//		float frameRate; // FrameRate
//		String[] frStr = _ffprobeParse.getAttribute("r_frame_rate", _ffprobeParse.hasVideo()).split("/");
//		frameRate = Float.parseFloat(frStr[0]);
//		float tmp;
//		if ((tmp = Float.parseFloat(frStr[1])) != 0.0)
//			frameRate /= tmp;
		
		
		//num of frme
		_ffmpeg = new FfmpegLocator();
		String ffPath = StaticUtils.padWithQuotes(_ffmpeg.getFfPath(_ffmpeg.FFMPEG).getAbsolutePath());
		
		String durationStr = _ffprobeParse.getAttribute("duration", _ffprobeParse.hasVideo());
		long duration = 2; //assuming that the video is at least one sec
		if (!durationStr.equals(""))
			duration = (long)(Float.parseFloat(durationStr));
		else { //if the duration doesn't appear in streams, it may appear in format
			duration = getDuration();
		}
		
		long offset = duration/2; //final offset
		
		String[] cmd = {ffPath,"-ss",Long.toString(offset),"-i",_file.getAbsolutePath(),"-vframes","1","-q:v","2","-f","image2","-vf","\"scale=iw*min(64/iw\\,64/ih):ih*min(64/iw\\,64/ih),pad=64:64:(64-iw)/2:(64-ih)/2\"","-"};
		try {
			_thumbnail = new ImageIcon(StaticUtils.getStdOutByteArr(cmd));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
