package com.declum.naduvar.locking.db;

import java.util.Date;

/**
 * It stores the information about the lock (created date, modified date, key
 * and path of lock)
 * 
 * @author clement
 * 
 */
public class LockStruct {

	/**
	 * Holds the Key of Lock
	 */
	private String lockKey;

	/**
	 * Holds the Path of Lock
	 */
	private String lockPath;

	/**
	 * Holds the Created Date of Lock
	 */
	private Date createdTime;

	/**
	 * Holds the Modified Date of Lock
	 */
	private Date modifiedTime;

	/**
	 * Returns the key for the lock
	 * 
	 * @return
	 */
	public String getLockKey() {
		return this.lockKey;
	}

	/**
	 * Set the key for the lock
	 * 
	 * @param lockKey
	 */
	public void setLockKey(String lockKey) {
		this.lockKey = lockKey;
	}

	/**
	 * Returns the path of the lock
	 * 
	 * @return
	 */
	public String getLockPath() {
		return this.lockPath;
	}

	/**
	 * Set path for the lock
	 * 
	 * @param lockPath
	 */
	public void setLockPath(String lockPath) {
		this.lockPath = lockPath;
	}

	/**
	 * Returns Created date for the Lock
	 */
	public Date getCreatedTime() {
		return this.createdTime;
	}

	/**
	 * Set Created date for the Lock
	 * 
	 * @param createdTime
	 */
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * Returns modified date for the Lock
	 * 
	 * @return
	 */
	public Date getModifiedTime() {
		return this.modifiedTime;
	}

	/**
	 * Set modified date for the Lock
	 * 
	 * @param modifiedTime
	 */
	public void setModifiedTime(Date modifiedTime) {
		this.modifiedTime = modifiedTime;
	}

	/**
	 * Just returns in organized way
	 */
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return "Created: " + this.createdTime + "\tModified: "
				+ this.modifiedTime + "\tPath: " + this.lockPath + "\tKey: "
				+ this.lockKey;
	}
}
