package org.bm.p2p.navigablep2p;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;

import org.apache.log4j.Logger;

/**
 * 
 * @author duanshuiliu
 * еĽڵ
 *
 */
public class Node {
	static final int BUCKETS = 16; // Ͱ(ֵ32ıҲ168)
	private int K = 5; // ÿͰԪظ

	static Logger logger = Logger.getLogger(Node.class.getName());
	
	private int failNum = 0; // ھӽڵʱظڵĸ
	
	private BitSet nodePosition; //ڵλ

	private ArrayList<Node> neighbors[]; // ھӽڵб[ĳԪֵǾǸýڵͱڵľ]
	
	// ΪdistanceĽڵneighborھӽڵб
	public void setNeighbor(Node neighbor, int distance) {
		int i;
		// 벻ںϷΧڣ˳
		if (distance < 0 || distance >= BUCKETS) return;
		
		// ΪdistanceͰԪظK
		int KK = (int) Math.max(1,Math.pow(2, K-(BUCKETS-1-distance)));
		// distanceͰûѸýڵͰ
		if ( neighbors[distance].size() < KK ) {
			for (i = 0; i < neighbors[distance].size(); i++) {
				//ڵѾڣ򷵻
				if (neighbors[distance].get(i)==neighbor){
					failNum ++;
					return;
				}
			}
			neighbors[distance].add(neighbor);
		}
		else {
			//ͰͰѡһ̭̭㷨ʹãο Kadmelia
			Random random = new Random();
			int chosedIdx = random.nextInt(KK+1);
			if (chosedIdx < KK)
				neighbors[distance].set(chosedIdx, neighbor);
			
		}
	}
	// þΪdistanceĳھ()
	public Node getNeighbor(int distance) {
		if (distance<0||distance>=BUCKETS) return null;
		if (neighbors[distance].size() > 0) {
			Random random = new Random();
			int chosenIdx = random.nextInt(neighbors[distance].size());
			return neighbors[distance].get(chosenIdx);
		}
		return null;
	}

	// þĿڵtargetNodeĳھ(ӦͰھ)
	public Node getNeighbor(Node targetNode) {
		Node neighbor = null;
		int distance = this.getDistanceFrom(targetNode);
		if (distance<0||distance>=BUCKETS) return null;

		int minDistance = distance;
		// ھӽڵбѡ
		if (neighbors[distance].size() > 0) {
			for (int i = 0; i < neighbors[distance].size(); i++) {
				if (neighbors[distance].get(i).getDistanceFrom(targetNode) < minDistance) {
					minDistance = neighbors[distance].get(i).getDistanceFrom(targetNode);
					neighbor = neighbors[distance].get(i);
				}
			}
		}
		return neighbor;
	}

	// þΪdistanceгھ
	public ArrayList<Node> getNeighbors(int distance) {
		return neighbors[distance];
	}
	
	// ھ
	public ArrayList<Node> getNeighbors() {
		ArrayList<Node> allNeighbors = new ArrayList<Node>();
		for (int j = 0; j < Node.BUCKETS; j++) {
			if (this.getNeighbors(j).size() > 0) {
				for (int k = 0; k < this.getNeighbors(j).size(); k++) {
					allNeighbors.add(this.getNeighbors(j).get(k));
				}
			}
		}
		return allNeighbors;
	}

	// ھе
	public int getMaxDistance() {
		int i;
		for (i=BUCKETS-1;i>=0;i--) {
			if (getNeighbor(i)!=null) break;
		}
		return i;
	}
	
	// óھеС
	public int getMinDistance() {
		int i;
		for (i=0;i<BUCKETS;i++) {
			if (getNeighbor(i)!=null) break;
		}
		return i;
	}
	
	// ýڵĳھӸ
	public int getOutNeighborNum() {
		int neighborNum = 0;
		for (int i = 0; i < BUCKETS; i++) {
			neighborNum += neighbors[i].size();
		}
		return neighborNum;
	}
	
	// ɾһھ
	public int delNeighbor(Node neighbor) {
		int ret = -1;
		int distance = this.getDistanceFrom(neighbor);
		if (this.getNeighbors(distance).size()>0) {
			for (int i=0;i<this.getNeighbors(distance).size();i++) {
				if (this.getNeighbors(distance).get(i)==neighbor) {
					this.getNeighbors(distance).remove(i);
					ret = 0;
					break;
				}
			}
		}
		return ret;
	}
	

	//ʼڵ㣬λΪֵ
	@SuppressWarnings("unchecked")
	public Node() {
		super();
		this.K = BUCKETS / 4; //ȱʡÿͰ
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandom();
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			neighbors[i] = new ArrayList<Node>();
		}
	}
	
	//ʼڵ㣬ÿͰɲk max(1,2^(k-(BUCKETS-1-distance)))
	@SuppressWarnings("unchecked")
	public Node(int k) {
		super();
		this.K = k ; //ÿͰ
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandom();
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			neighbors[i] = new ArrayList<Node>();
		}
	}

	//ʼڵ㣬λúͽڵnodeľdistanceѡȡ
	@SuppressWarnings("unchecked")
	public Node(Node node, int distance) {
		super();
		this.K = BUCKETS / 4; //ȱʡÿͰ
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandomByDistance(node, distance);
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			neighbors[i] = new ArrayList<Node>();
		}
	}

	// ʼڵ㣬λȷ
	@SuppressWarnings("unchecked")
	public Node(BitSet nodePosition) {
		super();
		this.nodePosition = nodePosition;
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			neighbors[i] = new ArrayList<Node>();
		}
	}

	// ɽڵλ
	public void setNodePositionRandom() {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS<32)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		for (i =0 ; i < ((BUCKETS<32)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS<32)?BUCKETS:32); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}
	
	//ɺͽڵnodeľΪdistanceĽڵλ
	public void setNodePositionRandomByDistance(Node node, int distance) {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS==16)||(BUCKETS==8)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		assert(distance<BUCKETS&&distance>=0); // λ[0, BUCKETS-1]
		for (i =0 ; i < ((BUCKETS==16)||(BUCKETS==8)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS==8)?8:(BUCKETS==16?16:32)); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
		// Ӧλλ
		i = Node.BUCKETS-1;
		while (i>distance) {
			nodePosition.set(i, node.getNodePosition().get(i));
			i--;
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}

	public BitSet getNodePosition() {
		return nodePosition;
	}

	public void setNodePosition(BitSet nodePosition) {
		this.nodePosition = nodePosition;
	}
	
	// ͽڵnode֮ľ
	public int getDistanceFrom(Node node) {
		int ret = 0;
		// cloneڵ㣨ΪڼĹУxorڵľҪı䣩
		BitSet twinPosition = (BitSet) this.nodePosition.clone();
		twinPosition.xor(node.getNodePosition());
		ret = twinPosition.length() - 1;
		return ret;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((nodePosition == null) ? 0 : nodePosition.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Node other = (Node) obj;
		if (nodePosition == null) {
			if (other.nodePosition != null)
				return false;
		} else if (!nodePosition.equals(other.nodePosition))
			return false;
		return true;
	}
	
	// ڵھӽڵ
	public void outputNeighbors() {
		for (int i = 0; i < BUCKETS; i++) {
			if (neighbors[i].size()>0) {
				for (int j = 0; j < neighbors[i].size(); j++) {
					logger.info("neighbor "+i+"-"+j+" : "+neighbors[i].get(j).getNodePosition());
				}
			}
		}
	}

	// ýڵĳ/ھӸ
	public int getNeighborNum() {
		int neighborNum = 0;
		for (int i = 0; i < BUCKETS; i++) {
			neighborNum += neighbors[i].size();
		}
		return neighborNum;
	}
	
	// ýڵĳ/ھӸ(볤)
	public int[] getNeighborNumByDistance() {
		int[] neighborNum = new int[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			neighborNum[i] = neighbors[i].size();
		}
		return neighborNum;
	}
	
	public double getFailNum() {
		return failNum;
	}
}
