
package ch.simas.nbtostring.options;

import ch.simas.nbtostring.ToStringGenerator;
import ch.simas.nbtostring.builder.ToStringBuilderType;
import ch.simas.nbtostring.util.BuilderTypeComboBoxRenderer;


final class ToStringOptionsPanel extends javax.swing.JPanel {

    private static final long serialVersionUID = -7894419549210811333L;

    private final ToStringOptionsPanelController controller;

    ToStringOptionsPanel(final ToStringOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        // TODO listen to changes in form fields and call controller.changed()
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    arrayStyleBox = new javax.swing.JCheckBox();
    overrideBox = new javax.swing.JCheckBox();
    styleBox = new javax.swing.JComboBox(ToStringBuilderType.values());
    styleLabel = new javax.swing.JLabel();
    chainedAppendBox = new javax.swing.JCheckBox();
    showMethodsBox = new javax.swing.JCheckBox();

    org.openide.awt.Mnemonics.setLocalizedText(arrayStyleBox, org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_ArrayStyle"));
    arrayStyleBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        arrayStyleBoxActionPerformed(evt);
      }
    });

    org.openide.awt.Mnemonics.setLocalizedText(overrideBox, org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toStringOverride"));
    overrideBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        overrideBoxActionPerformed(evt);
      }
    });

    styleBox.setRenderer(new BuilderTypeComboBoxRenderer());
    styleBox.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(java.awt.event.ItemEvent evt) {
        styleBoxItemStateChanged(evt);
      }
    });

    styleLabel.setLabelFor(styleBox);
    org.openide.awt.Mnemonics.setLocalizedText(styleLabel, org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_CodeStyle"));

    org.openide.awt.Mnemonics.setLocalizedText(chainedAppendBox, org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_ChainAppends"));

    showMethodsBox.setSelected(true);
    org.openide.awt.Mnemonics.setLocalizedText(showMethodsBox, org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_showHideMethods"));

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
          .addComponent(showMethodsBox)
          .addComponent(arrayStyleBox)
          .addComponent(overrideBox)
          .addGroup(layout.createSequentialGroup()
            .addComponent(styleLabel)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(styleBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGap(18, 18, Short.MAX_VALUE)
            .addComponent(chainedAppendBox)))
        .addGap(130, 130, 130))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(arrayStyleBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(overrideBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(styleLabel)
          .addComponent(styleBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(chainedAppendBox))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(showMethodsBox)
        .addContainerGap(155, Short.MAX_VALUE))
    );

    layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {arrayStyleBox, chainedAppendBox, overrideBox, showMethodsBox, styleBox, styleLabel});

  }// </editor-fold>//GEN-END:initComponents

  private void arrayStyleBoxActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_arrayStyleBoxActionPerformed
      ToStringPreferences.getDefault().setArrayStyle(arrayStyleBox.isSelected());
  }//GEN-LAST:event_arrayStyleBoxActionPerformed

  private void overrideBoxActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overrideBoxActionPerformed
      ToStringPreferences.getDefault().setOverride(overrideBox.isSelected());
  }//GEN-LAST:event_overrideBoxActionPerformed

  private void styleBoxItemStateChanged (java.awt.event.ItemEvent evt) {//GEN-FIRST:event_styleBoxItemStateChanged
    final ToStringBuilderType selected = (ToStringBuilderType) styleBox.getSelectedItem();
    chainedAppendBox.setEnabled(selected == ToStringBuilderType.STRINGBUFFER || selected == ToStringBuilderType.STRINGBUILDER);
    ToStringPreferences.getDefault().setBuilderType(selected);
  }//GEN-LAST:event_styleBoxItemStateChanged


    void load() {
        ToStringPreferences def = ToStringPreferences.getDefault();
        arrayStyleBox.setSelected(def.getArrayStyle());
        styleBox.setSelectedItem(def.getBuilderType());
        overrideBox.setSelected(def.getOverride());
        chainedAppendBox.setSelected(def.isChainedAppend());

        // update the append box
        ToStringBuilderType type = (ToStringBuilderType) styleBox.getSelectedItem();
        chainedAppendBox.setEnabled(type == ToStringBuilderType.STRINGBUFFER || type == ToStringBuilderType.STRINGBUILDER);

        showMethodsBox.setSelected(def.isShowMethods());
    }

    void store() {
        ToStringPreferences def = ToStringPreferences.getDefault();
        def.setArrayStyle(arrayStyleBox.isSelected());
        def.setBuilderType((ToStringBuilderType) styleBox.getSelectedItem());
        def.setOverride(overrideBox.isSelected());
        def.setChainedAppends(chainedAppendBox.isSelected());
        def.setShowMethods(showMethodsBox.isSelected());
        // and finally store the values
        def.store();
    }

    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox arrayStyleBox;
  private javax.swing.JCheckBox chainedAppendBox;
  private javax.swing.JCheckBox overrideBox;
  private javax.swing.JCheckBox showMethodsBox;
  private javax.swing.JComboBox styleBox;
  private javax.swing.JLabel styleLabel;
  // End of variables declaration//GEN-END:variables
}
