package ch.simas.nbtostring.ui;

import ch.simas.nbtostring.ToStringGenerator;
import ch.simas.nbtostring.builder.ToStringBuilderType;
import ch.simas.nbtostring.options.ToStringPreferences;
import ch.simas.nbtostring.util.BuilderTypeComboBoxRenderer;
import java.awt.LayoutManager;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ElementHandle;

/**
 *
 * @author cperv
 */
public class ToStringPanel extends javax.swing.JPanel {

    private static final long serialVersionUID = -7850804304417213396L;

    final ElementNode.Description cDescription;
    final ElementNode.Description fDescription;

    /**
     * Creates new form ToStringPanel
     * @param cDescription the complete description including methods and fields
     * @param fDescription the description including fields only
     */
    public ToStringPanel(ElementNode.Description cDescription, ElementNode.Description fDescription) {
        this.cDescription = cDescription;
        this.fDescription = fDescription;
        initComponents();
        ToStringBuilderType builderType = ToStringPreferences.getDefault().getBuilderType();
        cbChainedAppend.setEnabled(builderType == ToStringBuilderType.STRINGBUFFER || builderType == ToStringBuilderType.STRINGBUILDER);
        cbChainedAppend.setSelected(ToStringPreferences.getDefault().isChainedAppend());
    }

    public List<ElementHandle<? extends Element>> getVariables() {

        return ((ElementSelectorPanel)elementSelector).getSelectedElements();
    }

    public ToStringBuilderType getToStringBuilderType() {
        return (ToStringBuilderType) cbListCodeStyle.getSelectedItem();
    }

    public boolean isArrayToString() {
        return cbArrayStyle.isSelected();
    }

    public boolean insertOverride() {
        return cbAddOverride.isSelected();
    }

    public boolean isChainedAppend() {
        return cbChainedAppend.isSelected();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    elementSelector = new ElementSelectorPanel(cDescription, fDescription);
    cbListCodeStyle = new javax.swing.JComboBox(ToStringBuilderType.values());
    codeStyleLabel = new javax.swing.JLabel();
    cbArrayStyle = new javax.swing.JCheckBox();
    cbAddOverride = new javax.swing.JCheckBox();
    selectorLabel = new javax.swing.JLabel();
    cbChainedAppend = new javax.swing.JCheckBox();
    cbShowHideMethods = new javax.swing.JCheckBox();

    // this is bit tricky, the GUI-Designer always try to set layouts for panels,
    // but if it do so, it overrides the default layout and nothing is displayed at
    // the end. So first get the LayoutManager and then re-add later.
    LayoutManager lm = elementSelector.getLayout();

    javax.swing.GroupLayout elementSelectorLayout = new javax.swing.GroupLayout(elementSelector);
    elementSelector.setLayout(elementSelectorLayout);
    elementSelectorLayout.setHorizontalGroup(
      elementSelectorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 301, Short.MAX_VALUE)
    );
    elementSelectorLayout.setVerticalGroup(
      elementSelectorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 345, Short.MAX_VALUE)
    );

    elementSelector.setLayout(lm);

    cbListCodeStyle.setSelectedItem(ToStringPreferences.getDefault().getBuilderType());
    cbListCodeStyle.setRenderer(new BuilderTypeComboBoxRenderer());
    cbListCodeStyle.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(java.awt.event.ItemEvent evt) {
        cbListCodeStyleItemStateChanged(evt);
      }
    });

    codeStyleLabel.setText(org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_CodeStyle"));

    cbArrayStyle.setSelected(ToStringPreferences.getDefault().getArrayStyle());
    cbArrayStyle.setText(org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_ArrayStyle"));

    cbAddOverride.setSelected(ToStringPreferences.getDefault().getOverride());
    cbAddOverride.setText(org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toStringOverride"));

    selectorLabel.setText(org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_select"));

    cbChainedAppend.setText(org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_ChainAppends"));

    cbShowHideMethods.setSelected(ToStringPreferences.getDefault().isShowMethods());
    cbShowHideMethods.setText(org.openide.util.NbBundle.getMessage(ToStringGenerator.class, "LBL_toString_showHideMethods"));
    cbShowHideMethods.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cbShowHideMethodsActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(cbShowHideMethods)
          .addGroup(layout.createSequentialGroup()
            .addComponent(codeStyleLabel)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cbListCodeStyle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGap(18, 18, 18)
            .addComponent(cbChainedAppend))
          .addComponent(cbArrayStyle)
          .addComponent(cbAddOverride)
          .addComponent(selectorLabel)
          .addComponent(elementSelector, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(selectorLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(elementSelector, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(codeStyleLabel)
          .addComponent(cbListCodeStyle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(cbChainedAppend))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(cbArrayStyle)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(cbAddOverride)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(cbShowHideMethods)
        .addContainerGap())
    );

    //((ElementSelectorPanel)elementSelector).doInitialExpansion(1);
  }// </editor-fold>//GEN-END:initComponents

    private void cbListCodeStyleItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cbListCodeStyleItemStateChanged
        final ToStringBuilderType selected = (ToStringBuilderType) cbListCodeStyle.getSelectedItem();
        cbChainedAppend.setEnabled(selected == ToStringBuilderType.STRINGBUFFER || selected == ToStringBuilderType.STRINGBUILDER);
    }//GEN-LAST:event_cbListCodeStyleItemStateChanged

    private void cbShowHideMethodsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbShowHideMethodsActionPerformed
        // TODO add your handling code here:
        ((ElementSelectorPanel)elementSelector).toggleMethodDisplay();
    }//GEN-LAST:event_cbShowHideMethodsActionPerformed


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox cbAddOverride;
  private javax.swing.JCheckBox cbArrayStyle;
  private javax.swing.JCheckBox cbChainedAppend;
  private javax.swing.JComboBox cbListCodeStyle;
  private javax.swing.JCheckBox cbShowHideMethods;
  private javax.swing.JLabel codeStyleLabel;
  private javax.swing.JPanel elementSelector;
  private javax.swing.JLabel selectorLabel;
  // End of variables declaration//GEN-END:variables

}
