package eu.danielhernandez.ejemplos.nombreceltibero.listener;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import org.hibernate.SessionFactory;

import eu.danielhernandez.ejemplos.nombreceltibero.utilities.HibernateUtil;

public class SessionManager implements PhaseListener{
	/**
	 * 
	 */
	private static final long serialVersionUID = -2738410480070452710L;;
	
	@Override
	public void afterPhase(PhaseEvent phase) {
		if(phase.getPhaseId()==PhaseId.RESTORE_VIEW){
			SessionFactory sf = HibernateUtil.getSessionFactory();
			sf.openSession();
		}else if(phase.getPhaseId()==PhaseId.RENDER_RESPONSE){
			SessionFactory sf = HibernateUtil.getSessionFactory();
			sf.getCurrentSession().close();
		}
	}

	@Override
	public void beforePhase(PhaseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public PhaseId getPhaseId() {
		// TODO Auto-generated method stub
		return null;
	}

}
