package com.inikolova.numericpuzzle;

/**
 * Instances of this class represent a position in a two-dimensional grid
 * Position with coordinates [0,0] corresponds to upper left
 * @author nikol
 *
 */
public class Position {
	private int x = -1;
	private int y = -1;
	
	/**
	 * Creates a position with specified coordinates
	 * @param x - the x coordiante
	 * @param y - the y coordinate
	 */
	public Position(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	/**
	 * Creates position with the same coordinates as the specified position
	 * @param position - the positions from which the coordinates will be taken
	 */
	public Position(Position position) {
		this(position.getX(), position.getY());
	}
	
	/**
	 * 
	 * @return The x coordinate
	 */
	int getX() {
		return this.x;
	}
	
	/**
	 * 
	 * @return The y coordinate
	 */
	int getY() {
		return this.y;
	}
	
	/**
	 * Updates the coordinates of the position
	 * @param x - the new x coordinate
	 * @param y - the new y coordinate
	 */
	void setLocation(int x, int y) {
		this.x = x;
		this.y = y;
	}
}
