package net.embedded_projects.octopus.ui.views;

import java.io.IOException;

import net.embedded_projects.octopus.Activator;
import net.embedded_projects.octopus.Octopus;
import net.embedded_projects.octopus.Octopus.ADC;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class ADCView extends ViewPart {

	private Octopus octo;
	private ADC adc;
	
	private Display display;
	private Spinner pollingSpinner;
	private Button[] adcCtrls = new Button[8];
	private Text[] adcTexts = new Text[8];
	
	private Thread adcThread;
	private boolean doPolling;
	private int pollingInterval = 300;
	
	@Override
	public void createPartControl(Composite parent) {
		FormToolkit toolkit = new FormToolkit(parent.getDisplay());
		ScrolledForm form = toolkit.createScrolledForm(parent);
		form.getBody().setLayout(new GridLayout(2, false));

		final Button connect = toolkit.createButton(form.getBody(), "Connect", SWT.TOGGLE);
		connect.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));

		connect.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(connect.getSelection())
					connect();
				else
					doPolling = false;
			}
		});

		toolkit.createLabel(form.getBody(), "Interval (ms");
		pollingSpinner = new Spinner(form.getBody(), SWT.BORDER | SWT.READ_ONLY);
		pollingSpinner.setMaximum(2000);		
		pollingSpinner.setMinimum(100);
		pollingSpinner.setIncrement(10);
		pollingSpinner.setSelection(pollingInterval);
		pollingSpinner.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				pollingInterval = pollingSpinner.getSelection();
			}
		});

		Label sep = toolkit.createSeparator(form.getBody(), SWT.HORIZONTAL);
		sep.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));
		
		for(int i=0; i<8; i++) {
			adcCtrls[i] = toolkit.createButton(form.getBody(), "ADC " + i, SWT.CHECK);
			adcCtrls[i].setEnabled(false);
			adcCtrls[i].setLayoutData(new GridData(GridData.BEGINNING));
			final int channel = i;
			adcCtrls[i].addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					try {
						adc.init(channel);
						adcTexts[channel].setEnabled(adcCtrls[channel].getSelection());
					} catch (IOException e1) {
						e1.printStackTrace();
					}
				}
			});
			adcTexts[i] = new Text(form.getBody(), SWT.BORDER | SWT.READ_ONLY);
			adcTexts[i].setEnabled(false);
			adcTexts[i].setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		}
	}

	private void connect() {
		adcThread = new Thread(new Runnable() {
			public void run() {
				try {
					octo = Activator.getDefault().getOctopus();
					adc = octo.getADC();

					doPolling = true;
					while(doPolling) {
						updateText();
						Thread.sleep(pollingInterval);
					}
					octo.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		adcThread.start();

		for(int i=0; i<8; i++)
			adcCtrls[i].setEnabled(true);
	}

	private void updateText() {
		display.asyncExec(new Runnable() {
			public void run() {
				for(int i=0; i<8; i++) 
					if(adcCtrls[i].getSelection())
						try {
							adcTexts[i].setText("" + adc.get(i));
						} catch (IOException e) {
							e.printStackTrace();
						}
			}
		});
	}

	@Override
	public void setFocus() {
		// TODO Auto-generated method stub

	}

}
