/*
 * demo.java
 * Simple demo programm that shows
 * how to access octopus with java,
 * using '_octopus.so' wrapped
 * with SWIG.
 */

class example
{
  public static void main(String[] args){
    try {
      // tell the system to load the shared library into memory
      System.loadLibrary("octopus");

      octopus_context oxo = new octopus_context();
      octopus.octopus_init(oxo);
      octopus.octopus_open(oxo);

      octopus.octopus_io_init(oxo,3);
      octopus.octopus_io_set_pin_direction_out(oxo,3);

      while(true){
	octopus.octopus_io_set_pin(oxo,3,1);
	Thread.sleep(1000);
	octopus.octopus_io_set_pin(oxo,3,0);
	Thread.sleep(1000);
      }

    } catch (Exception e) {
      e.toString();
    }
  }
}

