/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.rules;

import com.ohell.data.CardBasic;
import com.ohell.data.enums.CardColor;
import com.ohell.data.enums.CardStrength;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Test class for RulesManager - with help from Illy for brutt-force testing
 * @author vasko
 */
public class OhellRulesManagerTest {

    public OhellRulesManagerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    /**
     * Test of getCardsThatCanBePlayed method, of class OhellRulesManager.
     */
    @Test    
    public void testGetCardsThatCanBePlayed() {
        System.out.println("=================================================");
        System.out.println("getCardsThatCanBePlayed");
        CardBasic firstCard = new CardBasic(CardColor.DIAMONDS, CardStrength.EIGHT);
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.DIAMONDS, CardStrength.ACE),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.TWO),
                                         new CardBasic(CardColor.CLUBS, CardStrength.EIGHT),
                                         new CardBasic(CardColor.SPADES, CardStrength.EIGHT),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.QUEEN));
        List<Integer> expResult = Arrays.asList(0,1,4);
        List<Integer> result = OhellRulesManager.getCardsThatCanBePlayed(firstCard, cards);
        assertEquals(expResult, result);        
    }

    /**
     * Test of getCardsThatCanBePlayed method, of class OhellRulesManager.
     */
    @Test
    public void testGetCardsThatCanBePlayed1() {
        System.out.println("=================================================");
        System.out.println("getCardsThatCanBePlayed");
        CardBasic firstCard = new CardBasic(CardColor.HEARTS, CardStrength.EIGHT);
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.DIAMONDS, CardStrength.ACE),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.TWO),
                                         new CardBasic(CardColor.CLUBS, CardStrength.EIGHT),
                                         new CardBasic(CardColor.SPADES, CardStrength.EIGHT),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.QUEEN));
        List<Integer> expResult = Arrays.asList(0,1,2,3,4);
        List<Integer> result = OhellRulesManager.getCardsThatCanBePlayed(firstCard, cards);
        assertEquals(expResult, result);
    }

    /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.DIAMONDS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.CLUBS, CardStrength.JACK),
                                         new CardBasic(CardColor.HEARTS, CardStrength.SEVEN),
                                         new CardBasic(CardColor.SPADES, CardStrength.TEN),
                                         new CardBasic(CardColor.CLUBS, CardStrength.ACE));
        int expResult = 3;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

    /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex1() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.CLUBS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.CLUBS, CardStrength.THREE),
                                         new CardBasic(CardColor.CLUBS, CardStrength.ACE),
                                         new CardBasic(CardColor.CLUBS, CardStrength.TEN),
                                         new CardBasic(CardColor.CLUBS, CardStrength.JACK));
        int expResult = 1;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex2() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.HEARTS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.DIAMONDS, CardStrength.THREE),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.ACE),
                                         new CardBasic(CardColor.HEARTS, CardStrength.THREE),
                                         new CardBasic(CardColor.SPADES, CardStrength.JACK));
        int expResult = 2;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex3() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.SPADES;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.CLUBS, CardStrength.FIVE),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.ACE),
                                         new CardBasic(CardColor.HEARTS, CardStrength.KING),
                                         new CardBasic(CardColor.SPADES, CardStrength.NINE));
        int expResult = 3;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

      /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex4() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.CLUBS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.CLUBS, CardStrength.JACK),
                                         new CardBasic(CardColor.HEARTS, CardStrength.SIX),
                                         new CardBasic(CardColor.HEARTS, CardStrength.THREE),
                                         new CardBasic(CardColor.CLUBS, CardStrength.TEN));
        int expResult = 0;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex5() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.DIAMONDS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.CLUBS, CardStrength.KING),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.NINE),
                                         new CardBasic(CardColor.HEARTS, CardStrength.ACE),
                                         new CardBasic(CardColor.SPADES, CardStrength.JACK));
        int expResult = 1;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex6() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.HEARTS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.SPADES, CardStrength.KING),
                                         new CardBasic(CardColor.HEARTS, CardStrength.NINE),
                                         new CardBasic(CardColor.SPADES, CardStrength.ACE),
                                         new CardBasic(CardColor.HEARTS, CardStrength.JACK));
        int expResult = 3;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }
      /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex7() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.SPADES;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.SPADES, CardStrength.QUEEN),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.EIGHT),
                                         new CardBasic(CardColor.SPADES, CardStrength.TEN),
                                         new CardBasic(CardColor.SPADES, CardStrength.JACK));
        int expResult = 0;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }
     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex8() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.CLUBS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.DIAMONDS, CardStrength.SIX),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.NINE),
                                         new CardBasic(CardColor.HEARTS, CardStrength.JACK),
                                         new CardBasic(CardColor.SPADES, CardStrength.JACK));
        int expResult = 1;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex9() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.SPADES;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.HEARTS, CardStrength.KING),
                                         new CardBasic(CardColor.HEARTS, CardStrength.ACE),
                                         new CardBasic(CardColor.SPADES, CardStrength.JACK),
                                         new CardBasic(CardColor.SPADES, CardStrength.ACE));
        int expResult = 3;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex10() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.DIAMONDS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.SPADES, CardStrength.TEN),
                                         new CardBasic(CardColor.HEARTS, CardStrength.SIX),
                                         new CardBasic(CardColor.HEARTS, CardStrength.KING),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.THREE));
        int expResult = 3;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex11() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.CLUBS;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.CLUBS, CardStrength.SEVEN),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.THREE),
                                         new CardBasic(CardColor.HEARTS, CardStrength.ACE),
                                         new CardBasic(CardColor.CLUBS, CardStrength.FIVE));
        int expResult = 0;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }

     /**
     * Test of getWinnerHandIndex method, of class OhellRulesManager.
     */
    @Test
    public void testGetWinnerHandIndex12() throws Exception {
        System.out.println("getWinnerHandIndex");
        CardColor trump = CardColor.SPADES;
        List<CardBasic> cards = Arrays.asList(new CardBasic(CardColor.HEARTS, CardStrength.KING),
                                         new CardBasic(CardColor.DIAMONDS, CardStrength.ACE),
                                         new CardBasic(CardColor.SPADES, CardStrength.JACK),
                                         new CardBasic(CardColor.SPADES, CardStrength.ACE));
        int expResult = 3;
        int result = OhellRulesManager.getWinnerHandIndex_Trump(trump, cards);
        System.out.println(result);
        assertEquals(expResult, result);


    }



}