package com.ohell.data;

import com.ohell.data.enums.CardColor;
import com.ohell.data.enums.CardStrength;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import static javax.persistence.GenerationType.IDENTITY;

@Entity
public class Card extends CardBasic implements Serializable {

    private Long id;
    private String label;

    public Card() {
        super();
    }

    @Override
    @Enumerated(value = EnumType.STRING)
    public CardColor getColor() {
        return super.getColor();
    }

    @Override
    @Enumerated(value = EnumType.STRING)
    public CardStrength getStrength() {
        return super.getStrength();
    }

    @Transient
    public String getLabel(){
        return label;
    }

    public Card(CardColor color, CardStrength strength) {
        super(color, strength);
    }

    private Card(CardBasic cb){
        super(cb.getColor(), cb.getStrength());
    }

    protected static List<Card> getFullCardDeck() {
        List<Card> result = new ArrayList<Card>();
        List<CardBasic> cbList = Card.getFullDeck();
        for (CardBasic cardBasic : cbList) {
            result.add(new Card(cardBasic));
        }
        return result;
    }

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString(){
        StringBuilder sb = new StringBuilder();
        sb.append("Card(id=");
        sb.append(id);
        sb.append("/color=");
        sb.append(super.getColor().name());
        sb.append("/strength=");
        sb.append(super.getStrength().name());
        sb.append(")");

        return sb.toString();
    }
}

