/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.data;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import static javax.persistence.GenerationType.IDENTITY;

/**
 *
 * @author vasko
 */
@Entity
public class GameTable implements Serializable {

    private long id;
    private String name;
    private int gamesStarted;
    private int gamesEnded;
    private List<Player> currentPlayers;
    private String gameType;
    private boolean isActive;

    public GameTable() {
        currentPlayers = new ArrayList<Player>();
    }

    public int getGamesEnded() {
        return gamesEnded;
    }

    public void setGamesEnded(int gamesEnded) {
        this.gamesEnded = gamesEnded;
    }

    public int getGamesStarted() {
        return gamesStarted;
    }

    public void setGamesStarted(int gamesStarted) {
        this.gamesStarted = gamesStarted;
    }

    @Id
    @GeneratedValue(strategy = IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Transient
    public List<Player> getCurrentPlayers() {
        return currentPlayers;
    }

    public void setCurrentPlayers(List<Player> currentPlayers) {
        this.currentPlayers = currentPlayers;
    }

    public String getGameType() {
        return gameType;
    }

    public void setGameType(String gameType) {
        this.gameType = gameType;
    }

    public boolean getIsActive() {
        return isActive;
    }

    public void setIsActive(boolean active) {
        this.isActive = active;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GameTable(id:");
        sb.append(id);
        sb.append("/name:");
        sb.append(name);
        sb.append("/gamesStarted:");
        sb.append(gamesStarted);
        sb.append("/gamesEnded:");
        sb.append(gamesEnded);
        sb.append("/gameType:");
        sb.append(gameType);
        sb.append("/isActive:");
        sb.append(isActive);
        sb.append(")");

        return sb.toString();
    }
}
