package com.ohell.data;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import static javax.persistence.GenerationType.IDENTITY;

@Entity
public class Hand implements Serializable{

    //TODO : for higher abstraction than one game - refactor in manner : pass this param in the constructor
    private static final int PLAYERS_COUNT = 4;
    
    private List<PlayerCardPair> playerCardPairs;

    private int handNumber;

    private int seatIndexOfFirstPlayer;

    private Long id;

    public Hand() {
    }

    public Hand (int handNumber,int seatIndexOfFirstPlayer) {
        this.handNumber = handNumber;
        this.seatIndexOfFirstPlayer = seatIndexOfFirstPlayer;
        playerCardPairs = new ArrayList<PlayerCardPair>();
    }

    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER)
    public List<PlayerCardPair> getPlayerCardPairs () {
        return playerCardPairs;
    }

    public void setPlayerCardPairs (List<PlayerCardPair> val) {
        this.playerCardPairs = val;
    }

    public int getHandNumber () {
        return handNumber;
    }

    public void setHandNumber (int val) {
        this.handNumber = val;
    }

    public int getSeatIndexOfFirstPlayer () {
        return seatIndexOfFirstPlayer;
    }

    public void setSeatIndexOfFirstPlayer (int val) {
        this.seatIndexOfFirstPlayer = val;
    }

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Transient
    public boolean isHandComplete(){
        return playerCardPairs.size() == PLAYERS_COUNT;
    }
    
    

}

