package com.ohell.data;


import com.ohell.relations.GamePlayerRel;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import static javax.persistence.GenerationType.IDENTITY;

@Entity
public class Player implements Serializable {
    
    private String nickname;

    private String password;

    private Long id;

    private Set<GamePlayerRel> gamePlayerRels = new HashSet<GamePlayerRel>();

    private int gamesPlayed;

    private int gamesWon;

    public Player () {
    }

    public String getNickname () {
        return nickname;
    }

    public void setNickname (String val) {
        this.nickname = val;
    }

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.LAZY, mappedBy="player")
    public Set<GamePlayerRel> getGamePlayerRels() {
        return this.gamePlayerRels;
    }

    public void setGamePlayerRels(Set<GamePlayerRel> gamePlayerRels) {
        this.gamePlayerRels = gamePlayerRels;
    }
    
    public int getGamesPlayed() {
        return gamesPlayed;
    }

    public void setGamesPlayed(int gamesPlayed) {
        this.gamesPlayed = gamesPlayed;
    }
    
    public int getGamesWon() {
        return gamesWon;
    }

    public void setGamesWon(int gamesWon) {
        this.gamesWon = gamesWon;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object o)    {
        if(! (o instanceof Player)){
            return false;
        }else{
            //id is database persistent id so it is safe to use it as criteria for equals method
            return this.id.longValue() == ((Player)o).getId().longValue();
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString(){
        StringBuilder sb = new StringBuilder();
        sb.append("Player(id:");
        sb.append(id);
        sb.append("/nickname:");
        sb.append(nickname);
        sb.append("/password:");
        sb.append(password);
        sb.append("/gamesPlayed:");
        sb.append(gamesPlayed);
        sb.append("/gamesWon:");
        sb.append(gamesWon);
        sb.append(")");

        return sb.toString();
    }

}

