/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.data;

import com.ohell.rules.OhellRulesManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import static javax.persistence.GenerationType.IDENTITY;
import javax.persistence.OneToOne;

/**
 *
 * @author vasko
 */
@Entity
public class PlayerGameScore implements Serializable{

    private long id;
    private Player player;
    private List<RoundStatistics> roundsStats;
    private int currentGameScore;

    public PlayerGameScore() {
    }

    public PlayerGameScore(Player player) {
        this.player = player;
        this.roundsStats = new ArrayList<RoundStatistics>();
        this.currentGameScore = 0;
    }



    public int getCurrentGameScore() {
        return currentGameScore;
    }

    public void setCurrentGameScore(int currentGameScore) {
        this.currentGameScore = currentGameScore;
    }

    @Id @GeneratedValue(strategy=IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @OneToOne
    public Player getPlayer() {
        return player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.LAZY)
    public List<RoundStatistics> getRoundsStats() {
        return roundsStats;
    }

    public void setRoundsStats(List<RoundStatistics> roundsStats) {
        this.roundsStats = roundsStats;
    }

    public void addRoundStatistics(int roundNumber, int announcedHands, int takenHands){
        RoundStatistics temp = new RoundStatistics(roundNumber, announcedHands, takenHands);
        roundsStats.add(temp);
        int points = OhellRulesManager.getPointsForTurn(announcedHands, takenHands);
        currentGameScore += points;
    }

}
