package com.ohell.data;

import com.ohell.relations.GamePlayerRel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import static javax.persistence.GenerationType.IDENTITY;

@Entity
public class Round implements Serializable {

    private List<PlayerInRound> players;
    private int roundNumber;
    private int totalHandsCount;
    private int playerOnTurn;
    private int playedHandsCount;
    private List<Hand> hands = new ArrayList<Hand>();
    private int indexOfDealerPlayer;
    private Card trump;
    private Long id;

//    private boolean isRoundFinished;
    public Round() {
    }

    //TODO - roundNumber is not zero-based depending on logic in the constructor - may lead to bugs - AND IT DID !!!
    //TODO - it seems that every Round has handom player to deal which is conflict with game rules
    //TODO - vasko suggests refactoring constructor body into private methods for clarity
    //ROUND_NUMBER IS NOT ZEROBASED - IT IS EQUAL TO THE NUMBER OF CARDS IN THE ROUND....
    public Round(int roundNumber, Dealer dealer, List<GamePlayerRel> gamePlayerRels, int dealerSeatIndex) {
        int playersCount = gamePlayerRels.size();

        // Initialize roundNumber and totalHandsCount
        this.roundNumber = roundNumber;
        if (roundNumber < Card.CARDS_COUNT / playersCount) {
            this.totalHandsCount = roundNumber;
        } else {
            this.totalHandsCount = Card.CARDS_COUNT / playersCount;
        }

        // Initialize players
        this.players = new ArrayList<PlayerInRound>();
        for (int i = 0; i < playersCount; i++) {
            PlayerInRound tmp = new PlayerInRound();
            tmp.setPlayer(gamePlayerRels.get(i).getPlayer());
            this.players.add(tmp);
        }

        // Deal cards
        dealer.shuffle();
        for (int i = 0; i < this.totalHandsCount * playersCount; i++) {
            int index = i % playersCount;
            players.get(index).addCard(dealer.dealCard());
        }

        // Set trump
        trump = dealer.dealCard(); //deal card will return null if all cards are dealt - so null means no trump

        // Decide first dealer
        this.indexOfDealerPlayer = dealerSeatIndex;
        this.playerOnTurn = (this.indexOfDealerPlayer + 1) % playersCount;
        playedHandsCount = 0;

        //init first hand
        initNextHand(playerOnTurn);
    }

    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    public List<Hand> getHands() {
        return hands;
    }

    public void setHands(List<Hand> hands) {
        this.hands = hands;
    }

    public Hand currentHand() {
        return hands.get(hands.size() - 1);
    }

    public int getIndexOfDealerPlayer() {
        return indexOfDealerPlayer;
    }

    public void setIndexOfDealerPlayer(int val) {
        this.indexOfDealerPlayer = val;
    }

    public int getPlayedHandsCount() {
        return playedHandsCount;
    }

    public void setPlayedHandsCount(int val) {
        this.playedHandsCount = val;
    }

    public int getPlayerOnTurn() {
        return playerOnTurn;
    }

    public void setPlayerOnTurn(int val) {
        this.playerOnTurn = val;
    }

    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    public List<PlayerInRound> getPlayers() {
        return players;
    }

    public void setPlayers(List<PlayerInRound> val) {
        this.players = val;
    }

    public int getRoundNumber() {
        return roundNumber;
    }

    public void setRoundNumber(int val) {
        this.roundNumber = val;
    }

    public int getTotalHandsCount() {
        return totalHandsCount;
    }

    public void setTotalHandsCount(int val) {
        this.totalHandsCount = val;
    }

    public Card getTrump() {
        return trump;
    }

    public void setTrump(Card val) {
        this.trump = val;
    }

    @Id
    @GeneratedValue(strategy = IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    //Logic for this method is implemented in OhellGame makeMove method
    public void updateRoundWithPlayerMove(Player p, Card c) {
        if (hands != null) {
            Hand currentHand = currentHand();
            PlayerInRound playerInRound = getPlayerInRound(p);
        }
    }

    public void updateRoundWithPlayerAnnounce(Player p, Announce a) {
        PlayerInRound playerInRound = getPlayerInRound(p);
        if(playerInRound != null){
            playerInRound.makeAnnounce(a);
        }else{
            //should never get here
            System.out.println("Exception - playerInRound cannot be NULL");
            throw new RuntimeException("Exception - playerInRound cannot be NULL");
        }
    }

    private PlayerInRound getPlayerInRound(Player p) {
        for (PlayerInRound playerInRound : players) {
            if (playerInRound.getPlayer().getId().equals(p.getId())) {
                return playerInRound;
            }
        }
        return null;
    }

    /**     
     * @return the seatIndex of the player that wins the hand so that it will be used
     * to set the first player to make move in the next hand
     */
//    @Transient
//    private  int getLastHandWinner() {
//        int result = -1;
//        try {
//            List<Card> cards = new ArrayList<Card>();
//            Hand hand = currentHand();
//            for (PlayerCardPair temp : hand.getPlayerCardPairs()) {
//                cards.add(temp.getPlayedCard());
//            }
//            int poss = OhellRulesManager.getWinnerHandIndex(trump.getColor(), cards);
//            result = hand.getPlayerCardPairs().get(poss).getSeatIndex();
//
//        }catch(OhellRulesManagerException e){
//            System.err.println("Exception in getHandWinner: "+e.getMessage());
//        }
//
//        return result;
//    }
    public void initNextHand(int seatIndex) {
        if(!isRoundOver()){
            setupNextHand(seatIndex);
        }
    }

    private void setupNextHand(int seatIndex) {
        Hand hand = new Hand(playedHandsCount + 1, seatIndex);
        hands.add(hand);
    }

    @Transient
    public boolean isRoundOver() {
        return totalHandsCount == hands.size() && hands.get(hands.size() - 1).isHandComplete();
    }

//    /**
//     * Flag for monitoring whether or not the round is complete - will be set by the Game owning the Round
//     */
//    public boolean getIsRoundFinished() {
//        return isRoundFinished;
//    }
//
//    /**
//     * Flag for monitoring whether or not the round is complete - will be set by the Game owning the Round
//     */
//    public void setIsRoundFinished(boolean roundFinished) {
//        this.isRoundFinished = roundFinished;
//    }
}

