/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.client.data;

import com.ohell.client.ui.custom.components.announces.AnnounceBean;
import com.ohell.client.ui.custom.components.score.ScoreTableModel;
import com.ohell.data.Announce;
import com.ohell.data.Card;
import com.ohell.data.Player;
import com.ohell.data.enums.CardColor;
import com.ohell.exception.OhellRulesManagerException;
import com.ohell.rules.OhellRulesManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author vasko
 */
public class GameBean implements AnnounceBean{

    //announces are sent from server - they hold id/code/name properties
    private HashMap<Integer, Announce> announces;

    private boolean isAnnounceState;

    private int seatIndexOfHostPlayer;
    
    private int playerToPlayNext;    
    private int lastPlayedPlayer = -1;

    private ScoreTableModel scoreTableModel;

    /**
     * currentHand needs to be initialized in theh beginning of the game. After that, when a Hand is over(it has 4 cards in it)
     * >b>initNextHand<b/> method is called and the new currentHand is initialized
     */
    private Hand currentHand = new Hand();


//    private List<Player> players;
    private List<Round> gameRounds;
    private Map<Integer,Player> playersSeatMap;

    public GameBean() {
        gameRounds = new ArrayList<Round>();
        scoreTableModel = new ScoreTableModel();
    }

    public boolean isCurrentHandOver(){
        return currentHand.isHandOver();
    }

    public ScoreTableModel getScoreTableModel() {
        return scoreTableModel;
    }

    public void setScoreTableModel(ScoreTableModel scoreTableModel) {
        this.scoreTableModel = scoreTableModel;
    }

    

    /**
     * The key is OhellAnnounce code - i.e. the countOfHandsAnnounced.
     * This way announce object can be instantly obtained from ui chosen handsCount value and used in communication phase
     */
    public HashMap<Integer, Announce> getAnnounces() {
        return announces;
    }

    /**
     * The key is OhellAnnounce code - i.e. the countOfHandsAnnounced.
     * This way announce object can be instantly obtained from ui chosen handsCount value and used in communication phase
     */
    public void setAnnounces(HashMap<Integer, Announce> announces) {
        this.announces = announces;
    }

    public boolean isIsAnnounceState() {
        return isAnnounceState;
    }

    public void setIsAnnounceState(boolean isAnnounceState) {
        this.isAnnounceState = isAnnounceState;
    }

    public int getSeatIndexOfHostPlayer() {
        return seatIndexOfHostPlayer;
    }

    public void setSeatIndexOfHostPlayer(int seatIndexOfHostPlayer) {
        this.seatIndexOfHostPlayer = seatIndexOfHostPlayer;
    }

    public int getPlayerToPlayNext() {
        return playerToPlayNext;
    }

    public void setPlayerToPlayNext(int playerToPlayNext) {
        this.playerToPlayNext = playerToPlayNext;
    }

    public int getLastPlayedPlayer() {
        return lastPlayedPlayer;
    }

    public void setLastPlayedPlayer(int lastPlayedPlayer) {
        this.lastPlayedPlayer = lastPlayedPlayer;
    }



    public Player getPlayerAtSeatIndex(int seatIndex){
        return playersSeatMap.get(seatIndex);
    }

    public void setPlayersSeatMap(Map<Integer, Player> playersSeatMap) {
        this.playersSeatMap = playersSeatMap;
    }
    
    public List<Player> getPlayers() {
        return new ArrayList<Player>(playersSeatMap.values());
    }

    /**
     * Before next hand is inited with this method, player that takes the current hand should be
     * determined and the currentRound should be incremented accordingly
     */
    public void initNextHand(){
        currentHand = new Hand();
    }

    public Hand getCurrentHand(){
        return currentHand;
    }

    public void initNextRound(int roundIndex, Card trump){
        Round r = new Round(roundIndex, trump);
        gameRounds.add(r);

        //in the beginning of the round, it is AnnounceState and the player to go first is determined by round number
        isAnnounceState = true;
        playerToPlayNext = OhellRulesManager.firstToActInCurrentRound(roundIndex);
    }

    public List<Round> getGameRounds() {
        return gameRounds;
    }

    public Round getCurrentRound(){
        return gameRounds.get(gameRounds.size() - 1);
    }

    

   

    public void updateWithPlayedCard(int seatIndex, Card card){
        currentHand.addPlayedCard(card);
        lastPlayedPlayer = seatIndex;
        
        if(!currentHand.isHandOver()){            
            playerToPlayNext = OhellRulesManager.nextPlayerToAct(seatIndex);
        }else{
            //update currentRound with taken hand
            Round currentRound = getCurrentRound();
            Card trump = currentRound.getTrump();
            CardColor trumpColor = trump == null ? null : trump.getColor();
            try{
                //seatIndex is the fourthPlayer in the hand.Incrementing his seatIndex with one/modul 4 gives the firstPlayer in hand.
                //Adding to it the handWinnerNumber will give exactly the seatIndex of the winnerPlayer
                int firstPlayerSeatIndex = OhellRulesManager.nextPlayerToAct(seatIndex);

                int winnerSeatIndex = OhellRulesManager.getWinnerHandIndex(firstPlayerSeatIndex,trumpColor, currentHand.getCards());
                System.out.println("WinnerHand seatIndex="+winnerSeatIndex);
                playerToPlayNext = winnerSeatIndex;


                currentRound.incrementTakenHands(winnerSeatIndex);
                if(!currentRound.isRoundComplete()){                    
                    System.out.println("Round is not over");
                }else{
                    System.out.println("Round is over");
                    //after the end of round - update the score, the next round will be inited by serverInitRound object
                    updateScoreAfterEndOfRound();
                }
            }catch(OhellRulesManagerException e){
                e.printStackTrace();
            }            
        }
    }

    private void updateScoreAfterEndOfRound(){
        Round r = getCurrentRound();
        for(int i = 0; i < 4; i++){
            int announcedHands = r.getAnnounce(i);
            int takenHands = r.getTakenHands(i);
            updatePlayerRoundScore(r.getRoundNumber(), i, announcedHands, takenHands);
        }
    }

    private void updatePlayerRoundScore(int roundNumber, int seatIndex, int announcedHands, int takenHands){
        int rowIndex = roundNumber - 1;
        int columnIndex = ScoreTableModel.getScoreColumnIndex(seatIndex);
        int roundScore = OhellRulesManager.getPointsForTurn(announcedHands, takenHands);
        this.scoreTableModel.setValueAt(roundScore, rowIndex, columnIndex);

        String currentTotal = scoreTableModel.getValueAt(ScoreTableModel.ROW_INDEX_RESULTS, columnIndex).toString();
        System.out.println("currentTotal: "+currentTotal);
        int totalScore = Integer.parseInt(currentTotal) + roundScore;
        this.scoreTableModel.setValueAt(totalScore, ScoreTableModel.ROW_INDEX_RESULTS, columnIndex);
    }

    public boolean isItCurrentPlayerTurn(){
        System.out.println("seatIndexOfHostPlayer "+seatIndexOfHostPlayer);
        System.out.println("playerToPlayNext "+playerToPlayNext);
        return seatIndexOfHostPlayer == playerToPlayNext;
    }



    public void updateAnnounce(int seatIndex, Announce announce) {
        updateModelWithAnnounce(seatIndex, announce.getCode());

        //TODO : bind GameBoard fields to gameModel and update them through this method
        int columnIndex = ScoreTableModel.getAnnounceColumnIndex(seatIndex);
        int rowIndex = this.getCurrentRound().getRoundNumber() - 1;
        this.scoreTableModel.setValueAt(announce.getCode(), rowIndex, columnIndex);
    }

    private  void updateModelWithAnnounce(int seatIndex, int announce){
        Round currentRound = getCurrentRound();
        currentRound.setAnnounce(seatIndex, announce);

        lastPlayedPlayer = seatIndex;
        playerToPlayNext = OhellRulesManager.nextPlayerToAct(seatIndex);
        System.out.println("UPDATE_MODEL_WITH_ANNOUNCE: seatIndex="+seatIndex);
        System.out.println("UPDATE_MODEL_WITH_ANNOUNCE: playerToPlayNext="+playerToPlayNext);
        if(currentRound.isAnnouncesComeplete()){            
            isAnnounceState = false;
        }
    }

    public boolean isVisible() {
        System.out.println("isAnnounceState: "+isAnnounceState);
        return isAnnounceState && isItCurrentPlayerTurn();
    }

    public List<Integer> getPossibleAnnounces() {
        int sumOfAnnounces = 0;
        Object o;
        for (int i = 0; i < OhellRulesManager.PLAYERS_COUNT; i++) {
            o = getCurrentRound().getAnnounce(i);
            if(o != null){
                sumOfAnnounces += (Integer)o;
            }
        }
        List<Integer> list = OhellRulesManager.getPossibleAnnounces(this.getCurrentRound().getRoundNumber(), seatIndexOfHostPlayer, sumOfAnnounces);
        return list;
    }
}
