/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui;

import com.ohell.client.state.ClientState;
import com.ohell.client.state.LoginState;
import com.ohell.client.ui.custom.components.GameJPanel;
import com.ohell.client.ui.custom.components.LoginJPanel;
import com.ohell.client.ui.custom.components.TablesJPanel;
import com.ohell.client.ui.custom.components.TestChatJPanel;
import com.ohell.communication.clienttoserver.LeaveTableObject;
import com.ohell.communication.clienttoserver.RoundOverObject;
import com.ohell.communication.common.ChatObject;
import com.ohell.communication.common.AnnounceObject;
import com.ohell.communication.common.PlayedMoveObject;
import com.ohell.data.Announce;
import com.ohell.data.Card;
import com.ohell.data.Player;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 *
 * @author vasko
 */
public class OhellGameClient extends JFrame implements Runnable, ClientToServerComm, CardGameMakeMove {

    //TODO : state should support Enum constants so that business logic can determine gracefully the current state
    private ClientState state;

    //ui components
    LoginJPanel loginPanel;
    TablesJPanel tablesPanel;
    TestChatJPanel chatPanel;
    GameJPanel gamePanel;
    //communication objects
    private Socket connection; //used to connect to server
    private ObjectInputStream inputStream;
    private ObjectOutputStream outputStream;
    private String serverHostName;//server's host name
    private int serverPort;//server's port
    /**
     * This is the chatIdentiicator that will be used from the current player when he or she chats in a table.
     * It is returned from the server after a successful login.It maps the player's nickname , but it could
     * easily be another type of identification , for example player's id.
     */
    private Player player;

    public OhellGameClient(String host, int port) {
        serverHostName = host;
        serverPort = port;
        state = new LoginState(this);

//        this.addWindowListener(new WindowAdapter() {
//
//            @Override
//            public void windowClosing(WindowEvent e) {
//                try {
//                    System.exit(0);
//                } catch (IOException ex) {
//                    Logger.getLogger(ClientLoginJFrame.class.getName()).log(Level.SEVERE, null, ex);
//                }
//            }
//        });

        loginPanel = new LoginJPanel(this);
        add(loginPanel);

        handleCloseEvent();

        setSize(400, 300);
        setResizable(false);
        setVisible(true);
        setTitle("Login");
    }


    //TODO : extend logic to leave table/leave server so that server can handle it approprately
    //for now leave table is the same as leave server
    private void sendLeaveTableObject() {
        //if gamePanel is not null player is loged in and connection is already established
        if (gamePanel != null) {
            int tableId = gamePanel.getTableId();
            LeaveTableObject lto = new LeaveTableObject(tableId);
            sendData(lto);
        }
    }

    private void closeConnection() {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (connection != null) {
                connection.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleCloseEvent() {
        //very important to setCloseOperation to - DO_NOTHING_ON_CLOSE
        this.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

        //write custom conditinal close handling
        this.addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent we) {
                closeApplication(we);
            }
        });
    }

    private void closeApplication(WindowEvent we) {
        int choice = JOptionPane.showConfirmDialog(this, "Are you sure you want to close the application.");
        if (choice == JOptionPane.YES_OPTION) {
            sendLeaveTableObject();
            closeConnection();
            System.exit(0);
        } else {
            //do nothing here - user choose to continue using the application
        }
    }

    public void run() {
        Object o;
        while (true) {
            try {
                o = inputStream.readObject();
                state.processCommunicationObject(o);
            } catch (EOFException eof) {
                //user terminates client application - socket is closed in finally block
                System.out.println("EOF caurght - player quits application");
                break;
            } catch (IOException ex) {
                System.out.println("IOException: "+ex.getMessage());
                break;
            } catch (ClassNotFoundException ex) {
                System.out.println("ClassNotFoundException: "+ex.getMessage());
            }
        }//end while
    }//end run method
    //send message to server

    public void sendData(Object o) {//clients sends attemt for move to server and looses his turn
        try {
            outputStream.writeObject(o);
            outputStream.flush();
        } catch (IOException e) {
            System.out.println("Exception while sending to server");
            e.printStackTrace();
        }
    }//end method sendClickedSquare
/*
    public static void main(String[] args) {
    java.awt.EventQueue.invokeLater(new Runnable() {

    public void run() {
    OhellGameClient test = new OhellGameClient(SERVER_HOST, SERVER_PORT);
    }
    });
    }
     */

    public void sendChatObject(String message) {
        ChatObject chatObject = new ChatObject(player, message);
        sendData(chatObject);
    }

    public TestChatJPanel getChatPanel() {
        return chatPanel;
    }

    public void setChatPanel(TestChatJPanel chatPanel) {
        this.chatPanel = chatPanel;
    }

    public LoginJPanel getLoginPanel() {
        return loginPanel;
    }

    public void setLoginPanel(LoginJPanel loginPanel) {
        this.loginPanel = loginPanel;
    }

    public Player getPlayer() {
        return player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setState(ClientState state) {
        this.state = state;
    }

    public TablesJPanel getTablesPanel() {
        return tablesPanel;
    }

    public void setTablesPanel(TablesJPanel tablesPanel) {
        this.tablesPanel = tablesPanel;
    }

    public GameJPanel getGamePanel() {
        return gamePanel;
    }

    public void setGamePanel(GameJPanel gamePanel) {
        this.gamePanel = gamePanel;
    }

    public void makeMove(Card card) {
        System.out.println("Sending move to other players : (seatIndex=" + gamePanel.getSeatIndexOfPlayer() + "/card=" + card + ")");
        sendData(new PlayedMoveObject(gamePanel.getSeatIndexOfPlayer(), card));
    }

    public void makeAnnounce(Announce a){
        System.out.println("Sending announce to other players : (seatIndex=" + gamePanel.getSeatIndexOfPlayer() + "/announce=" + a.getCode() + ")");
        sendData(new AnnounceObject(gamePanel.getSeatIndexOfPlayer(), a));
    }

    public void sendAnnounce(Announce a) {
        sendData(new AnnounceObject(gamePanel.getSeatIndexOfPlayer(), a));
    }

    public boolean connectToServer() throws IOException {
        try {//connect to server and get streams
            connection = new Socket(InetAddress.getByName(serverHostName), serverPort);

            //very important to flush the first communication header for the corresponding output stream
            //otherwise , the corresponding new ObjectInputStream constructor will block forever
            outputStream = new ObjectOutputStream(connection.getOutputStream());
            outputStream.flush();

            inputStream = new ObjectInputStream(connection.getInputStream());

        } catch (IOException ioe) {
            throw new IOException(ioe);
        }

        //create and start thread for this client
        ExecutorService es = Executors.newFixedThreadPool(1);
        es.execute(this);//executes current client
        return true;
    }

    public void requestNextRound(int currentRoundNumber, int hostPlayerSeatIndex) {
        sendData(new RoundOverObject(currentRoundNumber, hostPlayerSeatIndex));
    }
}
