/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GameUI.java
 *
 * Created on 2010-6-30, 16:29:55
 */
package com.ohell.client.ui;

import com.ohell.client.ui.custom.components.score.ScoreTableModel;
import com.ohell.data.Player;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

/**
 *
 * @author User
 */
public class OhellGameClientOld extends javax.swing.JFrame implements Runnable {

    private ScoreTableModel tableModel;

    public ScoreTableModel getTableModel() {
        return tableModel;
    }

    public void setTableModel(ScoreTableModel tableModel) {
        this.tableModel = tableModel;
    }



    private Socket connection; //used to connect to server
    private Scanner input; //input from server
    private Formatter output; //output to server
    /**
     * This is very important - must be managed localy for the client application according to communication with server
     */
    private boolean myTurn = true;
    private String serverHostName;//server's host name
    private int serverPort;//server's port

    //constructor initializing GUI
    public OhellGameClientOld(String host, int port) {
        initComponents();
        serverHostName = host;//set server name
        serverPort = port;

        chatTextField.addActionListener(
                new ActionListener() {
                    // send message to server

                    public void actionPerformed(ActionEvent event) {
                        String msg = event.getActionCommand();
                        sendData(msg);
                        chatTextField.setText("");
                        displayMessage("Me:" + msg + "\n");
                    } // end method actionPerformed
                } // end anonymous inner class
                ); // end call to addActionListener

        setVisible(true);

        startClient();

        tableModel = new ScoreTableModel();
    }//end constructor

    //start the Client thread
    public void startClient() {

        try {//connect to server and get streams
            connection = new Socket(InetAddress.getByName(serverHostName), serverPort);
            input = new Scanner(connection.getInputStream());
            output = new Formatter(connection.getOutputStream());
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }//end try catch

        //create and start thread for this client
        ExecutorService es = Executors.newFixedThreadPool(1);
        es.execute(this);//executes current client
    }//end method startClient

    public void run() {
        while (true) {
            if (input.hasNextLine()) {
                processMessage(input.nextLine());
            }
        }//end while
    }//end run method

    //processign messages recieved by client
    private void processMessage(String message) {
        displayMessage(message + "\n");//any other message from server is not related to current game state
    }//end processMessage method


    //displaying message in displayArea using event-dispatch thread
    private void displayMessage(final String message) {
        SwingUtilities.invokeLater(
                new Runnable() {

                    public void run() {
                        chatTextArea.append(message);

                        //always scroll down
                        int endIndex = chatTextArea.getDocument().getLength() - 1;
                        chatTextArea.setCaretPosition(endIndex);
                    }//end run method
                }//end inner anonymous class
                );//end call to invokeLater
    }//end method displayMessage


    //send message to server
    public void sendData(String message) {//clients sends attemt for move to server and looses his turn
        System.out.println("right before sending to server");
        output.format("%s\n", message);
        output.flush();

    }//end method sendClickedSquare

    /** Creates new form GameUI */
    public OhellGameClientOld() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane3 = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        infoPanel = new javax.swing.JPanel();
        sitButton = new javax.swing.JButton();
        startButton = new javax.swing.JButton();
        standUpButton = new javax.swing.JButton();
        player2Label = new javax.swing.JLabel();
        player3Label = new javax.swing.JLabel();
        player4Label = new javax.swing.JLabel();
        nicknameP1Label = new javax.swing.JLabel();
        player1Label = new javax.swing.JLabel();
        nicknameP2Label = new javax.swing.JLabel();
        nicknameP3Label = new javax.swing.JLabel();
        nicknameP4Label = new javax.swing.JLabel();
        tabbedPane = new javax.swing.JTabbedPane();
        chatPanel = new javax.swing.JPanel();
        chatTextField = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        chatTextArea = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        scoreP1Label = new javax.swing.JLabel();
        scoreP2Label = new javax.swing.JLabel();
        scoreP3Label = new javax.swing.JLabel();
        scoreP4Label = new javax.swing.JLabel();
        tablePanel = new javax.swing.JPanel();

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setBackground(new java.awt.Color(0, 204, 51));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setResizable(false);

        infoPanel.setBackground(new java.awt.Color(102, 255, 255));

        sitButton.setText("sit");
        sitButton.setOpaque(false);

        startButton.setText("start");
        startButton.setOpaque(false);
        startButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startButtonActionPerformed(evt);
            }
        });

        standUpButton.setText("stand up");
        standUpButton.setOpaque(false);

        player2Label.setBackground(new java.awt.Color(0, 0, 0));
        player2Label.setForeground(new java.awt.Color(255, 255, 255));
        player2Label.setText(" player #2");
        player2Label.setOpaque(true);

        player3Label.setBackground(new java.awt.Color(0, 0, 0));
        player3Label.setForeground(new java.awt.Color(255, 255, 255));
        player3Label.setText(" player #3");
        player3Label.setOpaque(true);

        player4Label.setBackground(new java.awt.Color(0, 0, 0));
        player4Label.setForeground(new java.awt.Color(255, 255, 255));
        player4Label.setText(" player #4");
        player4Label.setOpaque(true);

        nicknameP1Label.setBackground(new java.awt.Color(255, 255, 255));
        nicknameP1Label.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        nicknameP1Label.setText(" MOPKOB");
        nicknameP1Label.setIconTextGap(0);
        nicknameP1Label.setOpaque(true);

        player1Label.setBackground(new java.awt.Color(0, 0, 0));
        player1Label.setForeground(new java.awt.Color(255, 255, 255));
        player1Label.setText(" player #1");
        player1Label.setOpaque(true);

        nicknameP2Label.setBackground(new java.awt.Color(255, 255, 255));
        nicknameP2Label.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        nicknameP2Label.setText(" Kloshi");
        nicknameP2Label.setIconTextGap(0);
        nicknameP2Label.setOpaque(true);

        nicknameP3Label.setBackground(new java.awt.Color(255, 255, 255));
        nicknameP3Label.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        nicknameP3Label.setText(" Nikme");
        nicknameP3Label.setIconTextGap(0);
        nicknameP3Label.setOpaque(true);

        nicknameP4Label.setBackground(new java.awt.Color(255, 255, 255));
        nicknameP4Label.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        nicknameP4Label.setText(" Joker");
        nicknameP4Label.setIconTextGap(0);
        nicknameP4Label.setOpaque(true);

        chatPanel.setBackground(new java.awt.Color(102, 255, 255));

        chatTextField.setFont(new java.awt.Font("Arial", 0, 12)); // NOI18N

        chatTextArea.setColumns(20);
        chatTextArea.setEditable(false);
        chatTextArea.setFont(new java.awt.Font("Arial", 0, 12)); // NOI18N
        chatTextArea.setRows(5);
        jScrollPane3.setViewportView(chatTextArea);

        javax.swing.GroupLayout chatPanelLayout = new javax.swing.GroupLayout(chatPanel);
        chatPanel.setLayout(chatPanelLayout);
        chatPanelLayout.setHorizontalGroup(
            chatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(chatTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE)
            .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE)
        );
        chatPanelLayout.setVerticalGroup(
            chatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, chatPanelLayout.createSequentialGroup()
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 264, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chatTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        tabbedPane.addTab("chat", chatPanel);

        jTable2.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4", "Title 5"
            }
        ));
        jScrollPane2.setViewportView(jTable2);

        tabbedPane.addTab("tab2", jScrollPane2);

        scoreP1Label.setBackground(new java.awt.Color(64, 172, 255));
        scoreP1Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        scoreP1Label.setText("120");
        scoreP1Label.setOpaque(true);

        scoreP2Label.setBackground(new java.awt.Color(64, 172, 255));
        scoreP2Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        scoreP2Label.setText("120");
        scoreP2Label.setOpaque(true);

        scoreP3Label.setBackground(new java.awt.Color(64, 172, 255));
        scoreP3Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        scoreP3Label.setText("120");
        scoreP3Label.setOpaque(true);

        scoreP4Label.setBackground(new java.awt.Color(64, 172, 255));
        scoreP4Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        scoreP4Label.setText("120");
        scoreP4Label.setOpaque(true);

        javax.swing.GroupLayout infoPanelLayout = new javax.swing.GroupLayout(infoPanel);
        infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(
            infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(nicknameP1Label, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(player1Label, javax.swing.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE))
                    .addComponent(scoreP1Label, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(infoPanelLayout.createSequentialGroup()
                        .addComponent(scoreP2Label, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup()
                        .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(nicknameP2Label, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(player2Label, javax.swing.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE))
                        .addContainerGap())))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(nicknameP3Label, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(player3Label, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 105, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(scoreP3Label, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(infoPanelLayout.createSequentialGroup()
                        .addComponent(scoreP4Label, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup()
                        .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(nicknameP4Label, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(player4Label, javax.swing.GroupLayout.PREFERRED_SIZE, 105, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addContainerGap())))
            .addGroup(infoPanelLayout.createSequentialGroup()
                .addComponent(sitButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(startButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(standUpButton)
                .addContainerGap())
            .addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 318, Short.MAX_VALUE)
        );
        infoPanelLayout.setVerticalGroup(
            infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(infoPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(player2Label)
                    .addComponent(player1Label))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nicknameP1Label)
                    .addComponent(nicknameP2Label))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(scoreP1Label, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(scoreP2Label, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(23, 23, 23)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(player3Label)
                    .addComponent(player4Label))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nicknameP3Label)
                    .addComponent(nicknameP4Label))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(scoreP3Label, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(scoreP4Label, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(36, 36, 36)
                .addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(sitButton)
                    .addComponent(startButton)
                    .addComponent(standUpButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 319, Short.MAX_VALUE))
        );

        tablePanel.setPreferredSize(new java.awt.Dimension(369, 515));

        javax.swing.GroupLayout tablePanelLayout = new javax.swing.GroupLayout(tablePanel);
        tablePanel.setLayout(tablePanelLayout);
        tablePanelLayout.setHorizontalGroup(
            tablePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 489, Short.MAX_VALUE)
        );
        tablePanelLayout.setVerticalGroup(
            tablePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 533, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(tablePanel, javax.swing.GroupLayout.DEFAULT_SIZE, 489, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(infoPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(tablePanel, javax.swing.GroupLayout.PREFERRED_SIZE, 533, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addComponent(infoPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void startButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_startButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    /*
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new OhellGameClientOld().setVisible(true);
            }
        });
    }
*/
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel chatPanel;
    private javax.swing.JTextArea chatTextArea;
    private javax.swing.JTextField chatTextField;
    private javax.swing.JPanel infoPanel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane3;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    private javax.swing.JLabel nicknameP1Label;
    private javax.swing.JLabel nicknameP2Label;
    private javax.swing.JLabel nicknameP3Label;
    private javax.swing.JLabel nicknameP4Label;
    private javax.swing.JLabel player1Label;
    private javax.swing.JLabel player2Label;
    private javax.swing.JLabel player3Label;
    private javax.swing.JLabel player4Label;
    private javax.swing.JLabel scoreP1Label;
    private javax.swing.JLabel scoreP2Label;
    private javax.swing.JLabel scoreP3Label;
    private javax.swing.JLabel scoreP4Label;
    private javax.swing.JButton sitButton;
    private javax.swing.JButton standUpButton;
    private javax.swing.JButton startButton;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JPanel tablePanel;
    // End of variables declaration//GEN-END:variables
}
