/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.*;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
//import javax.swing.JComponent;
import javax.swing.JPanel;


/**
 *
 * @author User
 */
public class CardImageJPanel extends JPanel {

    private int count;
    private ImageIcon img;
    private Location location;


    public CardImageJPanel(int count, Location location) {
        if (location == Location.LEFT ||
                location == Location.RIGHT) {
            this.img = new ImageIcon(getClass().getResource("/com/ohell/client/ui/images/cards/backH.png"));
        } else {
            this.img = new ImageIcon(getClass().getResource("/com/ohell/client/ui/images/cards/backV.png"));
        }
        this.count = count;
        this.location = location;
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int panelHeight = 0;
        int panelWidth = 0;

        if (location == Location.TOP ||
                location == Location.BOTTOM) {
            panelHeight = img.getIconHeight();
            panelWidth = (int) (img.getIconWidth() * GameBoardJPanel.relativeStep) * (count - 1) + img.getIconWidth();
        } else {
            panelHeight = (int) (img.getIconHeight() * GameBoardJPanel.relativeStep) * (count - 1) + img.getIconHeight();
            panelWidth = img.getIconWidth();
        }
        
        this.setSize(panelWidth + 20, panelHeight + 20);
        this.setPreferredSize(new Dimension(panelWidth + 20, panelHeight + 20));

        int hDelta = 0;
        int hStep = 0;
        int vDelta = 0;
        int vStep = 0;
        switch (location) {
            case TOP:
                hDelta = panelWidth - img.getIconWidth();
                hStep = -(int) (img.getIconWidth() * GameBoardJPanel.relativeStep);
                break;
            case BOTTOM:
                hDelta = 0;
                hStep = (int) (img.getIconWidth() * GameBoardJPanel.relativeStep);
                break;
            case LEFT:
                vDelta = 0;
                vStep = (int) (img.getIconHeight() * GameBoardJPanel.relativeStep);
                break;
            case RIGHT:
                vDelta = panelHeight - img.getIconHeight();
                vStep = -(int) (img.getIconHeight() * GameBoardJPanel.relativeStep);
                break;
        }
        for (int i = 0; i < count; i++) {
            img.paintIcon(this, g, hDelta, vDelta);
            hDelta += hStep;
            vDelta += vStep;
        }
    }

    public boolean removeCard() {
        count--;
        this.paintComponent(this.getGraphics());
        this.updateUI();
        this.getParent().repaint();
        return (count > 0);
    }

}
