/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.data.GameBean;
import com.ohell.client.ui.CardGameMakeMove;
import com.ohell.client.ui.util.CardUtil;
import com.ohell.client.ui.util.data.CardStrengthOrder;
import com.ohell.client.ui.util.data.ColorOrder;
import com.ohell.data.Card;
import com.ohell.data.enums.CardColor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

/**
 *
 * @author User
 */
public class CardJPanel extends JPanel {

    private GameBean gameModel;

    private CardTableJPanel cardTable;

    private List<CardJButton> cardButtons;
    private CardGameMakeMove makeMove;

    /**
     * Default hardcoded colorOrder - Hearts/Spades/Diamonds/Clubs. If this UI CardJPanel should be configured so that
     * user can choose custom color arangement, this property should be dinamically initialized on load or on update.
     */
    private ColorOrder colorOrder = new ColorOrder(CardColor.HEARTS, CardColor.SPADES, CardColor.DIAMONDS, CardColor.CLUBS);


    /**
     * Default hardcoded strengthOrder - DESC. If this UI CardJPanel should be configured so that
     * user can choose custom strength arangement, this property should be dinamically initialized on load or on update.
     */
    private CardStrengthOrder strengthOrder = CardStrengthOrder.ASC;


    /**
     * Patching....
     */
    private GameBoardJPanel gameBoard;

    public GameBoardJPanel getGameBoard() {
        return gameBoard;
    }

    public void setGameBoard(GameBoardJPanel gameBoard) {
        this.gameBoard = gameBoard;
    }


    public CardJPanel(List<Card> cards, CardGameMakeMove makeMove, CardTableJPanel cardTable, GameBean gameModel, GameBoardJPanel board) {
        this.gameBoard = board;
        this.cardTable = cardTable;
        this.makeMove = makeMove;
        cardButtons = new ArrayList<CardJButton>();

        this.gameModel = gameModel;


        int panelHeight = 0;
        cards = CardUtil.sortCards(cards, colorOrder, strengthOrder);
        for (int i = 0; i < cards.size(); i++) {
            Card tmpCard;
            CardJButton tmpCardButton;
            int cardHeight;

            tmpCard = cards.get(i);
            tmpCardButton = new CardJButton(tmpCard);
            cardHeight = tmpCardButton.getHeight();
            tmpCardButton.setEnabled(true);
            tmpCardButton.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    clickHandler((CardJButton) e.getSource());
                }
            });
            panelHeight = (panelHeight < cardHeight) ? cardHeight : panelHeight;
            this.add(tmpCardButton);
            cardButtons.add(tmpCardButton);
        }
        this.setSize(0, panelHeight);
        updatePanel(false);
        this.setLayout(null);
    }

    public void enableCardButtons(boolean isOnMove) {
        for(CardJButton button : cardButtons) {
            button.setEnabled(isOnMove);
        }
    }
    

    private void updatePanel(boolean repaint) {
        int panelWidth = 0;
        for (int i = cardButtons.size() - 1; i >= 0; i--) {
            int buttonWidth;
            CardJButton tmpButton;

            tmpButton = cardButtons.get(i);
            if (i > 0) {
                buttonWidth = (int) (tmpButton.getWidth() * GameBoardJPanel.relativeStep);
            } else {
                buttonWidth = tmpButton.getWidth();
            }
            tmpButton.setLocation(panelWidth, 0);
            panelWidth += buttonWidth;
        }
        this.setSize(panelWidth, this.getHeight());
        this.setPreferredSize(new Dimension(panelWidth, this.getHeight()));
        if (repaint) {
            this.getParent().repaint();
        }
        this.updateUI();
    }

    private void clickHandler(CardJButton clickedButton) {       

        //if player is not on turn to play, do nothing.
        if(!gameModel.isItCurrentPlayerTurn() || gameModel.isIsAnnounceState()){
            return;
        }
        
        //send move via communication output stream
        makeMove.makeMove(clickedButton.getCard());

        //updateGameModel
        gameModel.updateWithPlayedCard(gameModel.getSeatIndexOfHostPlayer(), clickedButton.getCard());
        System.out.println("IN ClickHandler - seatIndexOfHostPlayer = "+gameModel.getSeatIndexOfHostPlayer());
        
        //update UI
        cardButtons.remove(clickedButton);
        this.remove(clickedButton);
        updatePanel(true);

        //update CardGame panel with the played card = Location.BOTTOM is used because player is always position at the bottom of the screen
        gameBoard.updateBoardWithCardMove(clickedButton.getCard(), makeMove);
        
    }
}
