/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.Location;
import com.ohell.data.Card;
import com.ohell.client.ui.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

/**
 *
 * @author User
 */
public class CardTableJPanel extends JPanel {

    private String imgPath;
    private int imgW;
    private int imgH;
    private double imgWPart = 0.35;
    private double imgHPart = 0.4;
    private int paddingW = 15;
    private int paddingH = 15;
    private List<Card> cards;
    private List<Location> cardLocations;

    public CardTableJPanel(String imgPath) {
        this.imgPath = imgPath;
        cards = new ArrayList<Card>();
        cardLocations = new ArrayList<Location>();
        ImageIcon img = new ImageIcon(getClass().getResource(imgPath + "Clubs2.png"));
        imgW = img.getIconWidth();
        imgH = img.getIconHeight();
        int panelHeight = paddingH * 2 + (int) (imgH * (1 + imgHPart) + imgW * imgWPart);
        int panelWidth = paddingW * 2 + (int) (imgW * (1 + imgWPart) + imgH * imgHPart);
        this.setSize(panelWidth, panelHeight);
        this.setPreferredSize(new Dimension(panelWidth, panelHeight));
        this.setLayout(null);
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int panelHeight = this.getHeight();
        int panelWidth = this.getWidth();
        paddingH = (int) ((panelHeight - (imgH * (1 + imgHPart) + imgW * imgWPart))/2);
        paddingW = (int) ((panelWidth - (imgW * (1 + imgWPart) + imgH * imgHPart))/2);

        g.setColor(Color.GREEN);
        g.fillRect(0, 0, panelWidth, panelHeight);
        
        for (int i = 0; i < cards.size(); i++) {
            drawCard(g, cards.get(i), cardLocations.get(i));
        }
        this.updateUI();
    }

    public void addCard(Card card, Location location) {
        cards.add(card);
        cardLocations.add(location);
    }

    public void removeCards() {
        System.out.println("removeCards()");
        cards.clear();
        cardLocations.clear();
        updateUI();
    }

    private void drawCard(Graphics g, Card card, Location location) {
        ImageIcon tmpImg;
        switch (location) {
            case LEFT:
                tmpImg = new ImageIcon(
                        getClass().getResource(imgPath + Util.cardToImgName(card)));
                tmpImg.paintIcon(this, g, paddingW, paddingH + (int) (imgH * imgHPart));
                break;
            case TOP:
                tmpImg = new ImageIcon(
                        getClass().getResource(imgPath + Util.cardToImgName(card)));
                tmpImg.paintIcon(this, g, paddingW + (int) (imgW * imgWPart), paddingH);
                break;
            case RIGHT:
                tmpImg = new ImageIcon(
                        getClass().getResource(imgPath + Util.cardToImgName(card)));
                tmpImg.paintIcon(this, g, paddingW + (int) (imgW * imgWPart + imgH * imgHPart), paddingH + (int) (imgW * imgWPart));
                break;
            case BOTTOM:
                tmpImg = new ImageIcon(
                        getClass().getResource(imgPath + Util.cardToImgName(card)));
                tmpImg.paintIcon(this, g, paddingW + (int) (imgH * imgHPart), paddingH + (int) (imgW * imgWPart + imgH * imgHPart));
                break;
        }
    }
}
