/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.ClientToServerComm;
import com.ohell.communication.clienttoserver.LoginObject;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

/**
 *
 * @author User
 */
public class LoginJPanel extends JPanel {
    //ui objects

    private JLabel nicknameLabel;
    private JLabel passwordLabel;
    private JTextArea displayArea;
    private JTextField nicknameField;
    private JPasswordField passwordField;
    private JButton loginButton;
    private ClientToServerComm comm;
    private boolean isConnectionEstablished = false;

    public LoginJPanel(ClientToServerComm comm) {

        this.comm = comm;

        JPanel tmpPanel = new JPanel(new GridLayout(3, 1));
        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

        nicknameLabel = new JLabel("nickname:", SwingConstants.RIGHT);
        tmpPanel.add(nicknameLabel);

        nicknameField = new JTextField("Tomni");
        tmpPanel.add(nicknameField);


        passwordLabel = new JLabel("password:", SwingConstants.RIGHT);
        tmpPanel.add(passwordLabel);

        passwordField = new JPasswordField("a");
        tmpPanel.add(passwordField);

        prepareLoginButton(tmpPanel);

        add(tmpPanel);

        displayArea = new JTextArea(10, 20);
        displayArea.setEditable(false);
        add(new JScrollPane(displayArea));

    }

    private void prepareLoginButton(JPanel tmpPanel) {
        loginButton = new JButton("Login!");
        loginButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                if (!isConnectionEstablished) {
                    try {
                        isConnectionEstablished = comm.connectToServer();
                    } catch (IOException ex) {
                        ex.printStackTrace();
                        displayMessage("Can not connect to server. Try again later");
                        return;
                    }
                }
                sendData();
            }
        });

        loginButton.setSize(50, 30);
        tmpPanel.add(loginButton, BorderLayout.SOUTH);
    }

    public void displayMessage(final String message) {
        displayArea.append(message);
        displayArea.append("\n");
        //always scroll down
        int endIndex = displayArea.getDocument().getLength() - 1;
        displayArea.setCaretPosition(endIndex);
    }//end method displayMessage

    private void sendData() {
        String nickname = nicknameField.getText();
        String password = new String(passwordField.getPassword());
        LoginObject o = new LoginObject(nickname, password);
        comm.sendData(o);
    }
}
