/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.ClientToServerComm;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 *
 * @author vasko
 */
public class TestChatJPanel extends JPanel{

    private JTextArea displayArea;
    private JTextField chatTextField;
    private ClientToServerComm comm;
    private String nickname;

    public TestChatJPanel(ClientToServerComm comm) {
        this.comm = comm;
//        nickname = comm.getNickname();

        JPanel tmpPanel = new JPanel(new GridLayout(2, 1));
        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

        displayArea = new JTextArea(10, 20);
        displayArea.setEditable(false);
        tmpPanel.add(new JScrollPane(displayArea));


        chatTextField = new JTextField();
        chatTextField.addActionListener(
                new ActionListener() {
                    // send message to server

                    public void actionPerformed(ActionEvent event) {
                        String msg = event.getActionCommand();
                        sendData(msg);
                        chatTextField.setText("");
                        displayMessage(nickname+": " + msg);
                    } // end method actionPerformed
                } // end anonymous inner class
        ); // end call to addActionListener
        tmpPanel.add(chatTextField);

        add(tmpPanel);
        setSize(400, 400);
    }


     public void displayMessage(final String message) {
        displayArea.append(message);
        displayArea.append("\n");
        //always scroll down
        int endIndex = displayArea.getDocument().getLength() - 1;
        displayArea.setCaretPosition(endIndex);
    }//end method displayMessage

    private void sendData(String chatMessage) {
        comm.sendChatObject(chatMessage);
    }


}
