/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components.score;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 *
 * @author vasko
 */
public class ScoreTableModel implements TableModel {

    private static final String ROUND_NUMBER = "#";
    private static final int TRUPM_ROUNDS = 12;
    private static final int NO_TRUMP_ROUNDS = 4;
    private static final int ROWS = 17;
    public static final int ROW_INDEX_RESULTS = 16;
    public static final int COLUMNS = 9;
    private int playersBeforeGameStart;
    private Object[][] data = new Object[ROWS][COLUMNS];

    public ScoreTableModel() {
        playersBeforeGameStart = 0;

        //trupm round numbers
        for (int i = 0; i < TRUPM_ROUNDS; i++) {
            setValueAt(i + 1, i, 0);
        }
        //no trump round numbers
        setValueAt("I", TRUPM_ROUNDS, 0);
        setValueAt("II", TRUPM_ROUNDS + 1, 0);
        setValueAt("III", TRUPM_ROUNDS + 2, 0);
        setValueAt("IV", TRUPM_ROUNDS + 3, 0);
    }

    public int getRowCount() {
        return ROWS;
    }

    public int getColumnCount() {
        return COLUMNS;
    }

    //columnIndex/2 equals to seatIndex, because first column is RoundNumber, then it is PlayerName and blank (points won/announce).
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return ROUND_NUMBER;
        }
        return "";
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return data[rowIndex][columnIndex];
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        data[rowIndex][columnIndex] = aValue;
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public static int getAnnounceColumnIndex(int seatIndex) {
        return seatIndex * 2 + 2;
    }

    public static int getScoreColumnIndex(int seatIndex) {
        return seatIndex * 2 + 1;
    }
}
