/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components.score;

import com.ohell.data.Player;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

/**
 *
 * @author vasko
 */
public class ScoreTablePanel extends JPanel {

    private JTable table;
    private JScrollPane scrollPane;
    private ScoreTableModel model;

    public ScoreTableModel getModel() {
        return model;
    }

    public void setModel(ScoreTableModel model) {
        this.model = model;
    }

    public ScoreTablePanel(List<Player> players) {
        model = new ScoreTableModel();
        model.setValueAt("3,3", 3, 3);
        model.setValueAt("4,7", 4, 7);
        model.setValueAt("7,8", 7, 8);

        table = new JTable(model);
        scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);

        adjustColumnWidth();

        add(scrollPane);
    }

    private void adjustColumnWidth() {
        TableColumn column = null;
        for (int i = 1; i < ScoreTableModel.COLUMNS; i++) {
            column = table.getColumnModel().getColumn(i);
            if (i%2 == 0) {
                column.setPreferredWidth(40);
            } else {
                column.setPreferredWidth(90);
            }
        }
    }
}
