/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.client.ui.images;

import java.net.URL;
import javax.swing.ImageIcon;

/**
 * This class will return ImageIcon instances by a giver card or arrow name.
 * The purpose of this class is to obtain Resources from the packages in the distribution jar.
 * It is done using getResourses method for a current class. There is no need path to images to be
 * specified because it is used as absolute path and there will be thrown FileNotFound exception.
 * Instead getResource method will look in the class file package folder and sub-folders first.
 * @author vasko
 */
public class ImageIconFactory {


    public static ImageIcon getCardImage(String cardName){
        URL url = ImageIconFactory.class.getResource("cards/"+cardName);        
        return new ImageIcon(url);
    }

    public static ImageIcon getArrowImage(String arrowName){
        URL url = ImageIconFactory.class.getResource("arrow/"+arrowName);
        return new ImageIcon(url);
    }

}
