/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.server.service;

import com.ohell.data.Player;
import com.ohell.persistence.builders.QueryBuilderException;
import com.ohell.persistence.dao.PersistenceManagerDAO;
import java.util.List;

/**
 * This is Singleton Authentication service class that supports operations involving user Authentication
 * @author vasko
 */
public class AuthenticationService {

    private static AuthenticationService instance = new AuthenticationService();

    private AuthenticationService() {
    }

    public static AuthenticationService getInstance() {
        return instance;
    }

    public Player loginUser(String nickname, String password) {
        try {
            Player p = new Player();
            p.setNickname(nickname);
            p.setPassword(password);
            List<Player> playersFetched = PersistenceManagerDAO.findByExample(p);
            if(playersFetched.size() == 0){
                System.out.println("ERROR - fetched ZERO players with nickname:"+nickname+" and password:"+password);
                return null;
            }if(playersFetched.size() == 1){
                System.out.println("OK - Fetched one player with nickname:"+nickname+" and password:"+password);
                return playersFetched.get(0);
            }else{
                System.out.println("ERROR - Fetched more than one player with nickname:"+nickname+" and password:"+password);
                return null;
            }
        } catch (QueryBuilderException e) {
            e.printStackTrace();
            System.out.println("Error while trying to authenticate player: " + e.getMessage());
            return null;
        }
    }
}
