/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.server.ui;

import com.ohell.threads.OhellTableCommunicationMediator;
import java.util.List;

/**
 *
 * @author vasko
 */
public interface TableCommunicationMediatorsHolder {

    /**
     * This type of object should be given to every OhellPlayerThread.
     * When a playerThread receives EnterTableObject , it should look for the server's TableChatMediators
     * that are initialized in the server start (along with all the GameTables).When a playerThread
     * obtains all TableChatMediators available in the server , it should search them for the one
     * that is associated with the table that is passed in the EnterTableObject (the identification
     * of the GameTable object is made via its id).After the playerThread finds the appropriate
     * OhellTableChatMediator ,it will do two things:
     * First - store the mediator's instance , so that it can update the mediator Chat State - that is it
     * can say to the chat mediator - hey man , i am sending message to all other players
     *
     * Second - subscribes as an observer to this mediator , so when another playerThread updates the
     * mediator's ChatState, the mediator has a way to inform all its observers that the other player has
     * sent a ChatObject
     * @return
     */
    public List<OhellTableCommunicationMediator> getTableCommunicationMediatorsFromServer();

    /**
     * This method should be implemented so that mediatorsHolder can support event logging - for example
     * if user logs in or sits on a table. Expected simple implementation should be the message to be added
     * to a simple text area. Further extansion can log date/time status logs into the database so that
     * server usability/performance can be monitored from admin panel
     * @param message - the message that should be logged
     */
    public void log(String message);
}
