/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.test;

import com.ohell.communication.clienttoserver.LoginObject;
import com.ohell.communication.servertoclient.FailLoginObject;
import com.ohell.communication.servertoclient.TablesObject;
import com.ohell.data.GameTable;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 *
 * @author vasko
 */
public class TestClientLoginJFrame extends JFrame implements Runnable {

    private static final int SERVER_PORT = 11111;
    private static final String SERVER_HOST = "127.0.0.1";

    //ui objects
    private JTextArea displayArea;
    private JTextField nicknameField;
    private JPasswordField passwordField;
    private JButton loginButton;
    //communication objects
    private Socket connection; //used to connect to server
    private ObjectInputStream inputStream;
    private ObjectOutputStream outputStream;
    private String serverHostName;//server's host name
    private int serverPort;//server's port

    public TestClientLoginJFrame(String host, int port) {
        serverHostName = host;
        serverPort = port;

        nicknameField = new JTextField("enter nickname here");
        nicknameField.setSize(100, 5);
        add(nicknameField, BorderLayout.WEST);
        

        passwordField = new JPasswordField("enter password here");
        passwordField.setSize(100, 5);
        add(passwordField, BorderLayout.EAST);

        displayArea = new JTextArea(10, 20);
        displayArea.setEditable(false);
        add(new JScrollPane(displayArea), BorderLayout.NORTH);

        loginButton = new JButton("Login!");
        loginButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                String nickname = nicknameField.getText();
                String password = new String(passwordField.getPassword());
                LoginObject o = new LoginObject(nickname, password);
                sendData(o);
            }
        });
        loginButton.setSize(50, 30);
        add(loginButton,BorderLayout.SOUTH);

        setVisible(true);
        setSize(400,400);
        startClient();
    }


    //start the Client thread
    public void startClient() {

        try {//connect to server and get streams
            connection = new Socket(InetAddress.getByName(serverHostName), serverPort);

            //very important to flush the first communication header for the corresponding output stream
            //otherwise , the corresponding new ObjectInputStream constructor will block forever
            outputStream = new ObjectOutputStream(connection.getOutputStream());
            outputStream.flush();

            inputStream = new ObjectInputStream(connection.getInputStream());
            
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }//end try catch

        //create and start thread for this client
        ExecutorService es = Executors.newFixedThreadPool(1);
        es.execute(this);//executes current client
    }//end method startClient

    public void run() {
        Object o;
        while (true) {
            try {
                o = inputStream.readObject();
                processCommunicationObject(o);
            } catch (IOException ex) {
                ex.printStackTrace();
            } catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }//end while
    }//end run method

    //processign messages recieved by client
    private void processCommunicationObject(Object o) {
        if (o instanceof FailLoginObject) {
            FailLoginObject flo = (FailLoginObject) o;
            displayMessage(flo.getErrorMessage());
        }
        if (o instanceof TablesObject) {
            //this object is sent by server after successful authentication
            displayMessage("Successful login");
            TablesObject tableObject = (TablesObject) o;
            List<GameTable> tables = tableObject.getTables();
            for (GameTable t : tables) {
                displayMessage("Table sent from server: " + t);
            }
        }
    }//end processMessage method


    //displaying message in displayArea using event-dispatch thread
    private void displayMessage(final String message) {
        SwingUtilities.invokeLater(
                new Runnable() {

                    public void run() {
                        displayArea.append(message);
                        displayArea.append("\n");
                        //always scroll down
                        int endIndex = displayArea.getDocument().getLength() - 1;
                        displayArea.setCaretPosition(endIndex);
                    }//end run method
                }//end inner anonymous class
                );//end call to invokeLater
    }//end method displayMessage

    //send message to server
    public void sendData(Object o) {//clients sends attemt for move to server and looses his turn

        try {
            outputStream.writeObject(o);
            outputStream.flush();
        } catch (IOException e) {
            System.out.println("Exception while sending to server");
            e.printStackTrace();
        }

    }//end method sendClickedSquare
/*
    public static void main(String[] args) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                TestClientLoginJFrame test = new TestClientLoginJFrame(SERVER_HOST, SERVER_PORT);                
            }
        });

    }
 * */
}
