
package com.ohell.persistence.builders;

import org.hibernate.Query;

/**
 * Base interface for all query builders
 * @author vasko
 */
public interface QueryBuilder<T> {

    /**
     * Method that builds findByExample search query for Generic objects -
     * the search criteria is placed in the object passed to this method
     * @param object - generic object that holds the search criteria
     * @return Hibernate Query associated with open session so that results can be fetched
     */
    public Query buildFindByExampleQueryDAO(T object);
}
