/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.persistence.builders.impl;

import com.ohell.data.GameTable;
import com.ohell.persistence.builders.QueryBuilder;
import com.ohell.persistence.util.HibernateSessionUtil;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 *
 * @author vasko
 */
public class TableQueryBuilderImpl implements QueryBuilder<GameTable> {

    public TableQueryBuilderImpl() {
    }

    private static class TableSearchFields {

        public String tableName;
        public int gamesStarted;
        public int gamesEnded;
        public String gameType;
        public boolean isActive;

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("Search fields: (");
            buff.append(tableName);
            buff.append(',');
            buff.append(gamesStarted);
            buff.append(',');
            buff.append(gamesEnded);
            buff.append(',');
            buff.append(gameType);
            buff.append(',');
            buff.append(isActive);
            buff.append(')');

            return buff.toString();
        }

        public boolean hasOneField() {
            return (null != tableName && !tableName.isEmpty()) || (gamesStarted > 0) || (gamesEnded > 0) || (null != gameType && !gameType.isEmpty());
        }

        public String getWherePlayer() {
            StringBuilder str = new StringBuilder();
            boolean hasFirst = false;

            if (null != tableName && !tableName.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("tableName like :tableName ");
            }
            if (gamesEnded > 0) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("gamesEnded like :gamesEnded ");
            }
            if (gamesStarted > 0) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("gamesStarted like :gamesStarted ");
            }
            if (null != gameType && !gameType.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("gameType like :gameType ");
            }

            //always uses isActive query parameter
            if (hasFirst) {
                str.append("and ");
            } else {
                hasFirst = true;
            }
            str.append("isActive like :isActive ");


            return str.toString();
        }

        public void setQueryParamsPlayer(Query query) {
            if (null != tableName && !tableName.isEmpty()) {
                query.setParameter("tableName", tableName + "%"); //"%" means that database record should contain but not exactly match the given param value
            }
            if (gamesEnded > 0) {
                query.setParameter("gamesEnded", gamesEnded);
            }
            if (gamesStarted > 0) {
                query.setParameter("gamesStarted", gamesStarted);
            }
            if (null != gameType && !gameType.isEmpty()) {
                query.setParameter("gameType", gameType);
            }
            if(hasOneField()){
                //if there is onen field set , always use isActive param
                query.setParameter("isActive", isActive);
            }            
        }
    }

    public Query buildFindByExampleQueryDAO(GameTable gameTable) {

        TableSearchFields fields = new TableSearchFields();
        fields.tableName = gameTable.getName();
        fields.gamesStarted = gameTable.getGamesStarted();
        fields.gamesEnded = gameTable.getGamesEnded();
        fields.gameType = gameTable.getGameType();
        fields.isActive = gameTable.getIsActive();

        Session session = HibernateSessionUtil.getSession();
        session.clear();//to clear old query if it has cached result set for optimization

        // search Certlett objects
        String hql = "from GameTable p ";
        if (fields.hasOneField()) {
            hql += "where ";
            hql += fields.getWherePlayer();

            System.out.println("Query text: " + hql);
        }
        Query q = session.createQuery(hql);
        fields.setQueryParamsPlayer(q);

        return q;
    }

    public static void main(String[] args) {
//        Test TableQueryBuilder

    }
}
