/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.dao;

import com.ohell.persistence.builders.BuildersFactory;
import com.ohell.persistence.builders.QueryBuilder;
import com.ohell.persistence.builders.QueryBuilderException;
import java.util.List;
import org.hibernate.Query;

/**
 * This is Generic PersistenceManager class that plays the role of <strong>Director</strong> in the <strong>Builder pattern</strong> that is used to assemble Queries
 * for DB search.When object holding search criteria is passede to its findByExample method , the Director loads appropriate Builder
 * for the given object and the builder produces appropriate Query , which execution will return result list of the type of the
 * search criteria object passed to findByExample.
 *
 * This way , if there are transaction manipulations , they can be placed in the PersistenceManagerDAO methods and can be reused everytime
 * while the businesslogic for creating and assembling HQL queries is delegated to appropriate builder.
 *
 * That is - Builder Design Pattern rocks.
 *
 * This class also acts as a <strong>Fascade</strong> to Hiberante persistence API - its predefines interface is limited only to
 * functionality that can be used for any search criteria that can be useful for the OhellGame business logic.
 * @author vasko
 */
public class PersistenceManagerDAO extends PersistenceManagerBase{


    /**
     * This methods returns List of objects persistend in the DataBase that satisfy the search criteria stored in the
     * object passed as parameter
     * @param <T> - generic property specifying the search/result object Class
     * @param object - parameter that holds the search criteria
     * @return - list of results
     * @throws com.ohell.persistence.builders.QueryBuilderException
     */
    public static <T> List<T> findByExample(T object) throws QueryBuilderException{        
        QueryBuilder<T> builder = BuildersFactory.getInstance().getQueryBuilder(object);
        Query q = builder.buildFindByExampleQueryDAO(object);
        return q.list();
    }
}
