/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.test;

import com.ohell.data.GameTable;
import com.ohell.data.OhellGame;
import com.ohell.data.Player;
import com.ohell.persistence.builders.QueryBuilderException;
import com.ohell.persistence.dao.PersistenceManagerDAO;
import com.ohell.relations.GamePlayerRel;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author vasko
 */
public class TestObjectsInitialization {

    private static void addTable(){
        GameTable table = new GameTable();
        table.setName("Grinders Zone");
        table.setGameType("Ohell");
        table.setIsActive(true);
        table.setGamesStarted(0);
        table.setGamesEnded(0);

        table = PersistenceManagerDAO.saveObject(table);
        System.out.println("Table persisted:"+table);
    }
    
    private static void add_4_PlayersInDB() {
        Player pMazga = new Player();
        pMazga.setNickname("Mazga");
        pMazga.setPassword("mazga");
        pMazga.setGamesPlayed(3);
        pMazga.setGamesWon(0);

        Player pMOPKOB = new Player();
        pMOPKOB.setNickname("MOPKOB");
        pMOPKOB.setPassword("MOPKOB");
        pMOPKOB.setGamesPlayed(11);
        pMOPKOB.setGamesWon(7);

        Player pTomni = new Player();
        pTomni.setNickname("Tomni");
        pTomni.setPassword("12321");
        pTomni.setGamesPlayed(2);
        pTomni.setGamesWon(1);

        Player pJoker = new Player();
        pJoker.setNickname("Joker");
        pJoker.setPassword("Joker");
        pJoker.setGamesPlayed(0);
        pJoker.setGamesWon(0);

        pMazga = PersistenceManagerDAO.saveObject(pMazga);
        System.out.println("pMazga persisted with id: " + pMazga.getId());
        pMOPKOB = PersistenceManagerDAO.saveObject(pMOPKOB);
        System.out.println("pMOPKOB persisted with id: " + pMOPKOB.getId());
        pTomni = PersistenceManagerDAO.saveObject(pTomni);
        System.out.println("pTomni persisted with id: " + pTomni.getId());
        pJoker = PersistenceManagerDAO.saveObject(pJoker);
        System.out.println("pTomni persisted with id: " + pJoker.getId());
    }

    private static void testGameCreate() throws QueryBuilderException{
        OhellGame g = new OhellGame();

        Player p = new Player();
        List<Player> players = PersistenceManagerDAO.findByExample(p);
        List<GamePlayerRel> game_player_relations = new ArrayList<GamePlayerRel>();

        for(int i = 0 ; i < 4 ; i++){
            GamePlayerRel rel = new GamePlayerRel();
            rel.setGame(g);
            rel.setPlayer(players.get(i));
            rel.setSeatIndex(i);

            game_player_relations.add(rel);
            if(i == 3){
                break;
            }
        }

        g.setGamePlayerRels(game_player_relations);
        PersistenceManagerDAO.saveObject(g);
    }

    public static void main(String[] args) throws QueryBuilderException {
        addTable();

        add_4_PlayersInDB();

        testGameCreate();
    }
}
