package com.akujin.onemanga;

import java.util.Map;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;

public class mainMenu extends Activity {
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        getWindow().setTitle("OneManga");
        
        //Start Service
        OMservice.setMainActivity(this);
        Intent svc = new Intent(this, OMservice.class);
        startService(svc);
        
        String[] menuItems = {"List of All Mangas","Popular","Recently Updated"/*,"My Favorites","Settings"*/,"About"};
        
        setContentView(R.layout.animelist_layout);
        this.setupMenu(menuItems);
    }
    
    private void showAbout(Context c) {
    	Dialog dialog = new Dialog(c);

		dialog.setContentView(R.layout.about);
		dialog.setTitle("About OneManga for Android");

		TextView text = (TextView) dialog.findViewById(R.id.text);
		text.setText("An android client for OneManga.com. Read all your favorite mangas on your phone.\n" +
				"This project isn't affiliated with OneManga. All images are stored on OneManga's servers and only downloaded on demand.\n\n" +
				"The application is completely open source project under the GNUv3 license. See website for SVN." +
				"\n\n" + 
				"http://code.google.com/p/onemanga-android/" +
				"\n\n" +
				"I'm looking for anyone experianced at Android development to help with the GUI.");
	
		dialog.show();
    }
    
    private void setupMenu(String[] list) {
    	try {
	    	ArrayAdapter listItemAdapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, list);
	    	ListView lv = (ListView)this.findViewById(R.id.list_view_id);
	    	lv.setAdapter(listItemAdapter);

	    	lv.setOnItemClickListener(new OnItemClickListener(){
	    		public void onItemClick( AdapterView av, View v, int index, long arg){
	    			
	    			String selection = av.getItemAtPosition(index).toString();
	    			
	    			if(selection == "List of All Mangas") {
	    				if(OMservice.refreshAnimeList()) {
		    		        Intent myIntent = new Intent(v.getContext(), animelist.class);
		    		        startActivity(myIntent);
	    				}
	    			}
	    			
	    			if(selection == "Popular") {
	    				if(OMservice.refreshPopularList()) {
		    		        Intent myIntent = new Intent(v.getContext(), popularList.class);
		    		        startActivity(myIntent);
	    				}
	    			}
	    			
	    			if(selection == "Recently Updated") {
	    				if(OMservice.refreshRecentList()) {
		    		        Intent myIntent = new Intent(v.getContext(), recentList.class);
		    		        startActivity(myIntent);
	    				}
	    			}
	    			
	    			if(selection == "About") {
	    				showAbout(v.getContext());
	    			}
	    		}
	    	
	    	});
    	}
    	catch(Exception e) {
    		Log.e("Error:", e.toString(), e);
    	}
    }
    
    /* Creates the menu items */
    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 0, 0, "About").setIcon(android.R.drawable.ic_menu_info_details);
        return true;
    }

    /* Handles item selections */
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
        case 0:
            showAbout(this);
            return true;
        }
        return false;
    }
    
}
