package com.akujin.onemanga;

import java.util.Iterator;
import java.util.Map;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemSelectedListener;

public class recentList extends Activity {
	
	TextView selection;  
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        //requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
        //getWindow().setTitle("Recently Added Manga Chapters");
        
        try {
	        Map animes = OMservice.recentList;
	        String[] list = new String[animes.size()];
	        
	        Iterator it = animes.keySet().iterator();
	        int count = 0;
	        while (it.hasNext()) {
	            list[count] = it.next().toString();
	            count++;
	        }
	        
	        setContentView(R.layout.animelist_layout);
	        setupAnimeListView(list);
        }
    	catch(Exception e) {
    		Log.e("Error:", e.toString(), e);
    	}
    }
    
    private void setupAnimeListView(String[] list) {
    	try {
	    	ArrayAdapter listItemAdapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, list);
	    	ListView lv = (ListView)this.findViewById(R.id.list_view_id);
	    	lv.setAdapter(listItemAdapter);

	    	lv.setOnItemClickListener(new OnItemClickListener(){
	    		public void onItemClick( AdapterView av, View v, int index, long arg){

	    			OMservice.currentChapter = OMservice.recentList.get(av.getItemAtPosition(index).toString()).toString();
	    			
	    			if(OMservice.refreshPageList()) {
	    				Intent myIntent = new Intent(v.getContext(), pageView.class);
	    		        startActivity(myIntent);
	    			}
	    		}
	    	
	    	});
    	}
    	catch(Exception e) {
    		Log.e("Error:", e.toString(), e);
    	}
    }
	
}