import javax.swing.SwingUtilities;

import view.View;
import control.Control;
import model.Model;

class RunGame
{
    static Control control;
    static Model realModel;
    
    public static void main( String[] args )
    {
        try
        {
            realModel = new Model( "mapTestFile.map" );
        }
        catch ( Exception e )
        {
            e.printStackTrace();
            System.out.println( "Oh god I crashed." );
            System.exit( 1 );
        }
        final View view = new View();
        control = new Control();
        view.register( realModel, control );
        control.register( realModel, view );
        realModel.addGameListener( view );
        realModel.addGameListener( control );
        
        SwingUtilities.invokeLater( new Runnable()
        {
            public void run()
            {
                View.createAndShowGUI();
            }
        } );
    }
    
}
