package _bye_util;

/**
 * 
 * @author kagioglu
 */
public class Tester
{
    public static void main( String[] args )
    {
        int[][] testcase = Tester.composeTestCase1();
        for ( IntRecycler cyc : Tester.cyclers() )
        {
            Tester.runTestCase( testcase, cyc );
        }
    }
    
    private static IntRecycler[] cyclers()
    {
        return new IntRecycler[]
        {
            new LogTightIntRecycler(), new LogLeakyIntRecycler(), new ConstantLeakyRecycler()
        };
    }
    
    private static int[][] composeTestCase1()
    {
        return new int[][]
        {
            new int[]
            {
                20
            }, new int[]
            {
                5, 8, 14, 17, 3, 9, 16, 1, 11, 12
            }, new int[]
            {
                20
            }
        };
    }
    
    private static void runTestCase( int[][] testcase, IntRecycler cycler )
    {
        System.out.println( "initialize:" );
        for ( int i = 0; i < testcase[ 0 ][ 0 ]; i++ )
        {
            System.out.print( " " + cycler.newInt() );
        }
        System.out.println();
        
        System.out.println( "remover:" );
        for ( int n : testcase[ 1 ] )
        {
            System.out.print( " " + n );
            cycler.recycleInt( n );
        }
        System.out.println();
        
        System.out.println( "repopulator:" );
        for ( int i = 0; i < testcase[ 2 ][ 0 ]; i++ )
        {
            System.out.print( " " + cycler.newInt() );
        }
        System.out.println();
        System.out.println();
    }
}
