package kontrol;

import model.interfaces.selectable.ControllableModel;
import java.util.Hashtable;
import java.util.Map;
import java.awt.event.KeyEvent;

/**
 *
 * @author kagioglu
 */
public class GameInterpreter implements KeyInterpreter
{
    private interface GameRunnable
    {
        void run( GameManager manager );
    }
    
    private GameManager manager;
    private Map<Integer, GameRunnable> keymap;

    public GameInterpreter( ControllableModel cmodel )
    {
        this.manager = new GameManager(cmodel);
        this.initializeKeymap();
    }

    private void initializeKeymap()
    {
        class StartGame implements GameRunnable
        {
            public void run( GameManager manager )
            {
                manager.startGame();
            }
        }

        class EndGame implements GameRunnable
        {
            public void run( GameManager manager )
            {
                manager.endGame();
            }
        }

        this.keymap = new Hashtable<Integer, GameRunnable>();
        this.keymap.put(KeyEvent.VK_S, new StartGame());
        this.keymap.put(KeyEvent.VK_E, new EndGame());
    }

    public void interpret( KeyEvent event )
    {
        if(this.keymap.containsKey(event.getKeyCode()))
        {
            this.keymap.get(event.getKeyCode()).run(this.manager);
        }
    }

    public void gameTick()
    {
        //do nothing
    }
}
