package kontrol;

import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import model.interfaces.selectable.ControllableModel;
import model.interfaces.selectable.ControllablePlayer;
import model.TileTranslator;
import model.Game;
import model.GameListener;
import view.ViewOverview;
import view.ViewHUD;
import view.ViewViewPort;
import view.Vew;

/**
 *
 * @author kagioglu
 */
public class KeyInterceptor implements KeyListener, KeyEventRouter, GameListener
{
    private OverviewInterpreter unitOverview;
    private OverviewInterpreter structureOverview;
    private KeyInterpreter viewport;
    private KeyInterpreter game;

    private KeyInterpreter interpreter;

    public KeyInterceptor
    (
        Game game,
        TileTranslator translator,
        ControllableModel cmodel,
        GUI gui,
        GameListener listener,
        Vew vew,
        ViewOverview overview,
        ViewHUD hud,
        ViewViewPort viewport
    )
    {
        this.initializeInterpreters(cmodel, overview, hud, viewport);
        this.switchToGameInterpreter();
        vew.register(translator, this);
        game.addGameListener(listener);
        game.addGameListener(this);
        gui.createAndShowGUI();
    }

    private void initializeInterpreters
    (
        ControllableModel cmodel,
        ViewOverview overview,
        ViewHUD hud,
        ViewViewPort viewport
    )
    {
        this.game = new GameInterpreter(cmodel);
        
        ControllablePlayer cplayer = cmodel.getPlayer();
        
        this.unitOverview = new OverviewInterpreter
        (
            this,
            "Unit Overview",
            new UnitOverviewConverter(cplayer),
            overview

        );

        this.structureOverview = new OverviewInterpreter
        (
            this,
            "Structure Overview",
            new StructureOverviewConverter(cplayer),
            overview
        );

        this.viewport = new ViewportInterpreter
        (
            this,
            cplayer,
            hud,
            viewport
        );
    }

    public void keyPressed( KeyEvent event )
    {
        //do nothing
    }

    public void keyReleased( KeyEvent event )
    {
        this.interpreter.interpret(event);
    }

    public void keyTyped( KeyEvent event )
    {
        //do nothing
    }

    public void switchToUnitOverviewInterpreter()
    {
        this.structureOverview.closeOverview(); //gaurantee closed
        this.interpreter = this.unitOverview;
        this.unitOverview.openOverview();
    }

    public void switchToStructureOverviewInterpreter()
    {
        this.unitOverview.closeOverview(); //gaurantee closed
        this.interpreter = this.structureOverview;
        this.structureOverview.openOverview();
    }

    public void switchToViewportInterpreter()
    {
        this.unitOverview.closeOverview(); //gaurantee closed
        this.structureOverview.closeOverview(); //gaurantee closed
        this.interpreter = this.viewport;
    }

    public void switchToGameInterpreter()
    {
        this.unitOverview.closeOverview(); //gaurantee closed
        this.structureOverview.closeOverview(); //gaurantee closed
        this.interpreter = this.game;
    }

    public void onGameWin()
    {
        
        this.switchToGameInterpreter();
    }

    public synchronized void synchedonGameWin()
    {
        this.switchToGameInterpreter();
    }

    public void onGameLose()
    {
        this.switchToGameInterpreter();
    }

    public synchronized void synchedonGameLose()
    {
        this.switchToGameInterpreter();
    }

    public void onGameBegin()
    {
        this.switchToViewportInterpreter();
    }

    public synchronized void synchedonGameBegin()
    {
        this.switchToViewportInterpreter();
    }

    public void onTick()
    {
        this.interpreter.gameTick();
    }

    public synchronized void synchedOnTick()
    {
        this.interpreter.gameTick();
    }
}
