package kontrol;

import view.ViewOverview;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.Hashtable;

/**
 *
 * @author kagioglu
 */
public class OverviewInterpreter implements KeyInterpreter
{
    private interface OverviewRunnable
    {
        void run( OverviewManager manager );
    }

    private OverviewManager manager;
    private Map<Integer, OverviewRunnable> keymap;

    //unit overview manager

    public OverviewInterpreter(
        KeyEventRouter router,
        String name,
        HasList haslist,
        ViewOverview overview
    )
    {
        this.manager = new OverviewManager(
            overview,
            name,
            new String[] { "up = up", "down = down", "c = close", "q = queue" },
            haslist
        );
        this.initializeKeymap(router);
    }

    private void initializeKeymap( KeyEventRouter router )
    {
        class Up implements OverviewRunnable
        {
            public void run( OverviewManager manager )
            {
                manager.incrementSelection();
            }
        }

        class Down implements OverviewRunnable
        {
            public void run( OverviewManager manager )
            {
                manager.decrementSelection();
            }
        }
        
        class ToggleQueue implements OverviewRunnable
        {
            public void run( OverviewManager manager )
            {
                manager.toggleQueue();
            }
        }

        class Close implements OverviewRunnable
        {
            private KeyEventRouter router;
            public Close( KeyEventRouter router )
            {
                this.router = router;
            }
            public void run( OverviewManager manager )
            {
                manager.closeOverview();
                this.router.switchToViewportInterpreter();
            }
        }

        this.keymap = new Hashtable<Integer, OverviewRunnable>();
        this.keymap.put(KeyEvent.VK_UP, new Up());
        this.keymap.put(KeyEvent.VK_DOWN, new Down());
        this.keymap.put(KeyEvent.VK_Q, new ToggleQueue());
        this.keymap.put(KeyEvent.VK_C, new Close(router));
    }

    public void interpret( KeyEvent event )
    {
        if(this.keymap.containsKey(event.getKeyCode()))
        {
            this.keymap.get(event.getKeyCode()).run(this.manager);
        }
    }

    public void gameTick()
    {
        this.manager.refresh();
    }

    public void openOverview()
    {
        this.manager.openOverview();
    }

    public void closeOverview()
    {
        this.manager.closeOverview();
    }
}
