package kontrol;

import model.interfaces.selectable.ControllablePlayer;
import model.interfaces.selectable.SelectableStructure;
import model.interfaces.selectable.SelectableCommand;

/**
 *
 * @author kagioglu
 */
public class StructureOverviewConverter implements HasList
{
    class HasQueueStructureOverview implements HasQueue
    {
        private SelectableStructure structure;
        public HasQueueStructureOverview( SelectableStructure structure )
        {
            this.structure = structure;
        }
        public String getName()
        {
            return this.structure.getName();
        }
        public String[] getQueue()
        {
            SelectableCommand[] commands = this.structure.getQueue();
            String[] result = new String[commands.length];
            for(int i = 0; i < commands.length; i++)
            {
                result[i] = commands[i].getName();
            }
            return result;
        }
    }

    private ControllablePlayer cplayer;

    public StructureOverviewConverter( ControllablePlayer cplayer )
    {
        this.cplayer = cplayer;
    }
    
    public HasQueue[] getHasQueues()
    {
        SelectableStructure[] structures = this.cplayer.getStructures();
        HasQueue[] result = new HasQueue[structures.length];
        for(int i = 0; i < structures.length; i++)
        {
            result[i] = new HasQueueStructureOverview(structures[i]);
        }
        return result;
    }
}
