package kontrol;

import view.View;

/**
 *
 * @author kagioglu
 */
public class ViewProxy implements GUI
{
    private static boolean instaFAIL = false;
    private final boolean useRealView;

    public ViewProxy( boolean useRealView )
    {
        this.useRealView = useRealView;
    }

    public synchronized void createAndShowGUI()
    {
        if(ViewProxy.instaFAIL)
        {
            throw new RuntimeException("don't call this more than once");
        }
        else
        {
            ViewProxy.instaFAIL = true;
            if(this.useRealView)
            {
                View.createAndShowGUI();
            }
            else
            {
                FakeView.createAndShowGUI();
            }
        }
    }
}
